/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.loaders.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.loaders.impl.FileRootLoader;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.util.FileUtil;
import org.w3c.dom.Element;

public class URLRootLoader
extends FileRootLoader {
    public void load(XModelObject object) {
        if (this.isFilePath(this.getPath(object))) {
            super.load(object);
        } else {
            Element element = XMLUtil.getElement(this.getInputStream(object));
            if (element != null) {
                this.util().load(element, object);
            }
        }
    }

    public boolean save(XModelObject object) {
        if (this.isFilePath(this.getPath(object))) {
            return super.save(object);
        }
        return true;
    }

    public String getPath(XModelObject object) {
        return FileUtil.fileURLToFilePath((String)super.getPath(object));
    }

    public boolean isFilePath(String path) {
        return path != null && path.lastIndexOf(58) < 2;
    }

    public InputStream getInputStream(XModelObject object) {
        try {
            return new URL(this.getPath(object)).openConnection().getInputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public OutputStream getOutputStream(XModelObject object) {
        try {
            return new URL(this.getPath(object)).openConnection().getOutputStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

