/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.loaders.impl;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import org.jboss.tools.common.CommonPlugin;

public class EncodedProperties
extends Properties {
    private static final long serialVersionUID = 4112578634029123456L;
    private String encoding = "8859_1";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public EncodedProperties() {
        this((EncodedProperties)null);
    }

    public EncodedProperties(EncodedProperties defaults) {
        super(defaults);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public synchronized void load(InputStream inStream) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        LineReader lr = new LineReader(inStream);
        while ((limit = lr.readLine()) >= 0) {
            char c = '\u0000';
            int keyLen = 0;
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            while (keyLen < limit) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
                ++keyLen;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            try {
                String key = this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
                String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
                this.put(key, value);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private String readStream(InputStream is) {
        StringBuffer sb = new StringBuffer("");
        try {
            int l;
            byte[] b = new byte[4096];
            while ((l = is.read(b, 0, b.length)) >= 0) {
                sb.append(new String(b, 0, l, this.encoding));
            }
            is.close();
        }
        catch (IOException e) {
            CommonPlugin.getPluginLog().logError((Throwable)e);
        }
        return sb.toString();
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                } else {
                    outBuffer.append(aChar);
                }
            } else {
                switch (aChar) {
                    case ' ': {
                        if (x == 0 || escapeSpace) {
                            outBuffer.append('\\');
                        }
                        outBuffer.append(' ');
                        break;
                    }
                    case '\t': {
                        outBuffer.append('\\');
                        outBuffer.append('t');
                        break;
                    }
                    case '\n': {
                        outBuffer.append('\\');
                        outBuffer.append('n');
                        break;
                    }
                    case '\r': {
                        outBuffer.append('\\');
                        outBuffer.append('r');
                        break;
                    }
                    case '\f': {
                        outBuffer.append('\\');
                        outBuffer.append('f');
                        break;
                    }
                    case '!': 
                    case '#': 
                    case ':': 
                    case '=': {
                        outBuffer.append('\\');
                        outBuffer.append(aChar);
                        break;
                    }
                    default: {
                        if (aChar < ' ' || aChar > '~') {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                            outBuffer.append(EncodedProperties.toHex(aChar >> 12 & 0xF));
                            outBuffer.append(EncodedProperties.toHex(aChar >> 8 & 0xF));
                            outBuffer.append(EncodedProperties.toHex(aChar >> 4 & 0xF));
                            outBuffer.append(EncodedProperties.toHex(aChar & 0xF));
                            break;
                        }
                        outBuffer.append(aChar);
                    }
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    public synchronized void store(OutputStream out, String comments) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, this.encoding));
        if (comments != null) {
            EncodedProperties.writeln(awriter, "#" + comments);
        }
        EncodedProperties.writeln(awriter, "#" + new Date().toString());
        Enumeration<Object> e = this.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = (String)this.get(key);
            key = EncodedProperties.saveConvert(key, true);
            val = EncodedProperties.saveConvert(val, false);
            EncodedProperties.writeln(awriter, String.valueOf(key) + "=" + val);
        }
        awriter.flush();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static void main(String[] args) {
        String ps = "p1:v1 \\\n  hh \\\n gg\n\np2=v2\\u0034\\u0055";
        EncodedProperties p = new EncodedProperties();
        ByteArrayInputStream s = new ByteArrayInputStream(ps.getBytes());
        try {
            p.load(s);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        p.list(System.out);
    }

    class LineReader {
        char[] lineBuf = new char[1024];
        int inOff = 0;
        int inLimit = 0;
        String source = null;

        public LineReader(InputStream inStream) {
            this.source = EncodedProperties.this.readStream(inStream);
            this.inLimit = this.source.length();
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    if (len == 0 || isCommentLine) {
                        return -1;
                    }
                    return len;
                }
                c = this.source.charAt(this.inOff++);
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    return len;
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

