/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.impl.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintAList;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CountriesHelper {
    public static Map<String, String> countries = null;
    public static Map<String, String> languages = null;
    static Object initMonitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(XModel model) {
        if (countries != null) {
            return;
        }
        Object object = initMonitor;
        synchronized (object) {
            if (countries != null) {
                return;
            }
            countries = new TreeMap<String, String>();
        }
        countries.put("", "default");
        languages = new TreeMap<String, String>();
        languages.put("", "default");
        CountriesHelper.loadMap(countries, "meta/countries.txt");
        CountriesHelper.loadMap(languages, "meta/languages.txt");
        CountriesHelper.loadEntity(model, "ValidationFormset");
        CountriesHelper.loadEntity(model, "ValidationFormset11");
    }

    private static void loadEntity(XModel model, String entityName) {
        XModelEntity entity = model.getMetaData().getEntity(entityName);
        if (entity == null) {
            return;
        }
        CountriesHelper.loadAttribute(countries, entity, "country");
        CountriesHelper.loadAttribute(languages, entity, "language");
    }

    private static void loadAttribute(Map<String, String> map, XModelEntity entity, String attr) {
        XAttributeConstraintAList acl = (XAttributeConstraintAList)entity.getAttribute(attr).getConstraint();
        acl.setValues(map.keySet().toArray(new String[0]));
    }

    private static void loadMap(Map<String, String> map, String resource) {
        try {
            URL url = CountriesHelper.class.getClassLoader().getResource(resource);
            String s = FileUtil.readStream((InputStream)url.openStream());
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                int i = t.indexOf(46);
                int j = t.lastIndexOf(46);
                if (i < 0) continue;
                String code = t.substring(0, i);
                String name = t.substring(j + 1);
                map.put(code, name);
            }
        }
        catch (IOException e) {
            ModelPlugin.getPluginLog().logError("CountiesHelper:loadMap:" + e.getMessage());
        }
    }
}

