/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.RegularChildren;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderedChildren
extends RegularChildren {
    protected XModelObject[] list = EMPTY;
    protected List<XModelObject> alist = new ArrayList<XModelObject>();

    @Override
    public boolean areChildrenOrdered() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        super.clear();
        if (this.size() > 0) {
            OrderedChildren orderedChildren = this;
            synchronized (orderedChildren) {
                this.alist.clear();
                this.list = EMPTY;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XModelObject[] getObjects() {
        if (this.list == null) {
            OrderedChildren orderedChildren = this;
            synchronized (orderedChildren) {
                this.list = this.alist.toArray(new XModelObject[0]);
            }
        }
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addObject(XModelObject o) {
        if (!super.addObject(o)) {
            return false;
        }
        OrderedChildren orderedChildren = this;
        synchronized (orderedChildren) {
            this.alist.add(o);
            this.list = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeObject(XModelObject o) {
        if (!super.removeObject(o)) {
            return false;
        }
        int i = this.getIndex(o);
        if (i >= 0) {
            OrderedChildren orderedChildren = this;
            synchronized (orderedChildren) {
                if (this.alist.size() == 1) {
                    this.list = EMPTY;
                    this.alist.clear();
                } else {
                    this.alist.remove(i);
                    this.list = null;
                }
            }
        }
        return true;
    }

    @Override
    public synchronized int getIndex(XModelObject o) {
        return this.alist.indexOf(o);
    }

    @Override
    public synchronized boolean move(int from, int to) {
        int size = this.size();
        if (size == 0) {
            throw new IndexOutOfBoundsException();
        }
        if (to >= size) {
            to = size - 1;
        }
        if (from < 0 || from >= size || from == to) {
            return false;
        }
        XModelObject o = this.alist.get(from);
        int delta = to > from ? 1 : -1;
        int k = from;
        while (k != to) {
            this.alist.set(k, this.alist.get(k + delta));
            if (this.list != null) {
                this.list[k] = this.list[k + delta];
            }
            k += delta;
        }
        this.alist.set(to, o);
        if (this.list != null) {
            this.list[to] = o;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Comparator<XModelObject> c) {
        if (c == null) {
            c = this.comparator;
        }
        if (c == null) {
            return;
        }
        this.getObjects();
        OrderedChildren orderedChildren = this;
        synchronized (orderedChildren) {
            Arrays.sort(this.list, c);
            this.alist = this.asList(this.list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceChildren(XModelObject[] objects) {
        super.replaceChildren(objects);
        OrderedChildren orderedChildren = this;
        synchronized (orderedChildren) {
            this.alist = this.asList(objects);
            this.list = null;
        }
    }

    private List<XModelObject> asList(XModelObject[] objects) {
        ArrayList<XModelObject> n = new ArrayList<XModelObject>();
        int i = 0;
        while (i < objects.length) {
            n.add(objects[i]);
            ++i;
        }
        return n;
    }
}

