/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.icons.impl;

import java.util.Hashtable;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.meta.impl.XMetaDataConstants;
import org.jboss.tools.common.meta.impl.XMetaElementImpl;
import org.jboss.tools.common.model.icons.XIconList;
import org.jboss.tools.common.model.util.IconUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XIconListImpl
extends XMetaElementImpl
implements XIconList,
XMetaDataConstants {
    private Hashtable<String, String> iconnames = new Hashtable();
    private Hashtable<String, Image> eclipseImages = new Hashtable();

    public String getIconPath(String name, String defaultName) {
        String s = this.iconnames.get(name);
        return s == null ? this.iconnames.get(defaultName) : s;
    }

    public Image getImage(String name, String defaultname) {
        Image i = this.getImage(name);
        if (i == null && (i = this.getImage(defaultname)) != null) {
            this.eclipseImages.put(name, i);
        }
        return i;
    }

    public Image getImage(String name) {
        Image image = this.eclipseImages.get(name);
        if (image == null) {
            String picture = this.iconnames.get(name);
            if (picture == null) {
                return null;
            }
            image = IconUtil.getEclipseImage(picture);
            this.eclipseImages.put(name, image);
        }
        return image;
    }

    public void load(Element element) {
        this.load("", element);
    }

    protected void load(String prefix, Element element) {
        if (element == null) {
            return;
        }
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 1) {
                String nm;
                Element c = (Element)n;
                String dp = c.getNodeName();
                if (dp.equals("ICON")) {
                    nm = String.valueOf(prefix) + c.getAttribute("name");
                    String pt = c.getAttribute("path");
                    this.iconnames.put(nm, pt);
                } else if (dp.equals("GROUP")) {
                    nm = c.getAttribute("name");
                    this.load(String.valueOf(prefix) + nm + ".", c);
                } else {
                    this.load(String.valueOf(prefix) + dp + ".", c);
                }
            }
            ++i;
        }
    }
}

