/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.impl;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.tools.common.CommonPlugin;
import org.jboss.tools.common.meta.impl.EmptyHandler;
import org.jboss.tools.common.meta.impl.MetaLibLoader;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.xml.SAXValidator;
import org.jboss.tools.common.xml.XMLEntityResolverImpl;
import org.jboss.tools.common.xml.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class Parser
implements ContentHandler {
    protected static final String FATAL_ERROR_PROCESSING_FEATURE_ID = "http://apache.org/xml/features/continue-after-fatal-error";
    protected static final String ENTITY_RESOLVER_PROPERTY_ID = "http://apache.org/xml/properties/internal/entity-resolver";
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String VALIDATION_SCHEMA_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String VALIDATION_SCHEMA_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String VALIDATION_DYNAMIC_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String DEFAULT_SAX_PARSER_CLASS_NAME = "org.apache.xerces.parsers.SAXParser";
    Element documentElement = null;
    Element current = null;

    Parser() {
    }

    public void parse(InputStream is) {
        this.parse(new InputSource(is));
    }

    public void parse(InputSource is) {
        XMLReader parser = this.createParser();
        if (parser == null) {
            return;
        }
        try {
            parser.parse(is);
        }
        catch (SAXException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IOException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    XMLReader newInstance() throws SAXException {
        try {
            return (XMLReader)ModelPlugin.getDefault().getBundle().loadClass(DEFAULT_SAX_PARSER_CLASS_NAME).newInstance();
        }
        catch (ClassNotFoundException e1) {
            throw new SAXException("SAX2 driver class org.apache.xerces.parsers.SAXParser not found", e1);
        }
        catch (IllegalAccessException e2) {
            throw new SAXException("SAX2 driver class org.apache.xerces.parsers.SAXParser found but cannot be loaded", e2);
        }
        catch (InstantiationException e3) {
            throw new SAXException("SAX2 driver class org.apache.xerces.parsers.SAXParser loaded but cannot be instantiated (no empty public constructor?)", e3);
        }
        catch (ClassCastException e4) {
            throw new SAXException("SAX2 driver class org.apache.xerces.parsers.SAXParser does not implement XMLReader", e4);
        }
    }

    XMLReader createParser() {
        DefaultHandler handler = new DefaultHandler();
        XMLReader parserInstance = null;
        try {
            parserInstance = this.newInstance();
        }
        catch (SAXException e) {
            ModelPlugin.getPluginLog().logError("default parser failed: " + e.getMessage());
            return null;
        }
        SAXValidator.setFeature((XMLReader)parserInstance, (String)NAMESPACES_FEATURE_ID, (boolean)false);
        SAXValidator.setFeature((XMLReader)parserInstance, (String)NAMESPACE_PREFIXES_FEATURE_ID, (boolean)false);
        SAXValidator.setFeature((XMLReader)parserInstance, (String)VALIDATION_FEATURE_ID, (boolean)false);
        SAXValidator.setFeature((XMLReader)parserInstance, (String)VALIDATION_SCHEMA_FEATURE_ID, (boolean)false);
        SAXValidator.setFeature((XMLReader)parserInstance, (String)VALIDATION_SCHEMA_CHECKING_FEATURE_ID, (boolean)false);
        SAXValidator.setFeature((XMLReader)parserInstance, (String)VALIDATION_DYNAMIC_FEATURE_ID, (boolean)false);
        SAXValidator.setFeature((XMLReader)parserInstance, (String)FATAL_ERROR_PROCESSING_FEATURE_ID, (boolean)false);
        try {
            if (MetaLibLoader.validateMetaXML) {
                parserInstance.setProperty(ENTITY_RESOLVER_PROPERTY_ID, new XMLEntityResolverImpl());
            } else {
                parserInstance.setProperty(ENTITY_RESOLVER_PROPERTY_ID, new EmptyHandler());
            }
        }
        catch (SAXException e1) {
            CommonPlugin.getPluginLog().logError(String.valueOf(e1.getMessage()), (Throwable)e1);
        }
        parserInstance.setContentHandler(handler);
        parserInstance.setErrorHandler(handler);
        parserInstance.setContentHandler(this);
        return parserInstance;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String uri, String localName, String name) throws SAXException {
        Node p = this.current.getParentNode();
        if (p instanceof Element) {
            this.current = (Element)p;
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if (this.current == null) {
            this.documentElement = this.current = XMLUtilities.createDocumentElement((String)name);
        } else {
            this.current = XMLUtilities.createElement((Element)this.current, (String)name);
        }
        int l = atts.getLength();
        int i = 0;
        while (i < l) {
            String n = atts.getQName(i);
            String v = atts.getValue(i);
            this.current.setAttribute(n, v);
            ++i;
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

