/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.impl;

import org.jboss.tools.common.meta.constraint.XAdapter;
import org.jboss.tools.common.meta.impl.XAttributeImpl;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.w3c.dom.Element;

class AdapterHolder {
    private XAttributeImpl attribute;
    private XAdapter adapter;
    private String loader;
    private Element element;

    public void init(XAttributeImpl attribute, String loader, Element element) {
        this.attribute = attribute;
        this.loader = loader;
        this.element = element;
        this.adapter = null;
    }

    public XAdapter getAdapter() {
        if (this.adapter != null) {
            return this.adapter;
        }
        this.doGetAdapter();
        if (this.adapter == null) {
            this.adapter = new XAdapter();
        }
        return this.adapter;
    }

    private synchronized void doGetAdapter() {
        String loader = this.loader;
        Element element = this.element;
        if (this.adapter != null) {
            return;
        }
        XAdapter adapter = null;
        if (loader == null || loader.length() == 0) {
            adapter = new XAdapter();
        } else {
            String clsname = loader.indexOf(46) >= 0 ? loader : "org.jboss.tools.common.meta.impl.adapters.XAdapter" + loader;
            try {
                if (loader.length() > 0) {
                    adapter = (XAdapter)ModelFeatureFactory.getInstance().createFeatureInstance(clsname);
                }
            }
            catch (ClassCastException e) {
                ModelPlugin.getPluginLog().logError("XAttributeImpl:loadAdapter:" + e.getMessage());
            }
        }
        if (adapter == null) {
            adapter = new XAdapter();
        }
        adapter.reload(element);
        adapter.setConstraint(this.attribute.getConstraint());
        loader = null;
        element = null;
        this.adapter = adapter;
    }
}

