/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.popup;

import java.util.Iterator;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.ActionFactory;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.diagram.editors.model.ExpandableShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.OrmEditPart;

public class PopupMenuProvider
extends ContextMenuProvider {
    public static final String GROUP_OPEN_SOURCE = "open_source";
    public static final String GROUP_EDIT = "edit";
    public static final String GROUP_ADDITIONAL_ACTIONS = "additional_actions";
    private ActionRegistry actionRegistry;

    public PopupMenuProvider(EditPartViewer viewer, ActionRegistry actionRegistry) {
        super(viewer);
        this.actionRegistry = actionRegistry;
    }

    public void buildContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator(GROUP_OPEN_SOURCE));
        menu.add((IContributionItem)new Separator(GROUP_EDIT));
        menu.add((IContributionItem)new Separator(GROUP_ADDITIONAL_ACTIONS));
        IAction action = null;
        if (this.getViewer().getSelection() instanceof StructuredSelection) {
            Object first;
            Shape selectedShape = null;
            IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
            if (selection != null) {
                Object firstElement = selection.getFirstElement();
                Object obj = null;
                if (firstElement instanceof OrmEditPart) {
                    obj = ((OrmEditPart)firstElement).getModel();
                } else if (firstElement instanceof AbstractTreeEditPart) {
                    obj = ((AbstractTreeEditPart)firstElement).getModel();
                }
                if (obj != null && obj instanceof Shape) {
                    selectedShape = (Shape)obj;
                }
            }
            if (selectedShape != null && selection.size() == 1 && ((first = selectedShape.getOrmElement()) instanceof PersistentClass || first.getClass() == Property.class || first instanceof Table || first instanceof Column)) {
                action = this.getActionRegistry().getAction((Object)"org.jboss.tools.hibernate.ui.diagram.editors.actions.open.source");
                this.appendToGroup(GROUP_OPEN_SOURCE, action);
                this.createMenuItem(this.getMenu(), action);
                action = this.getActionRegistry().getAction((Object)"org.jboss.tools.hibernate.ui.diagram.editors.actions.open.mapping");
                this.appendToGroup(GROUP_OPEN_SOURCE, action);
                this.createMenuItem(this.getMenu(), action);
            }
            boolean addToggleVisibleStateMenu = false;
            boolean addToggleExpandStateMenu = false;
            Iterator it = selection.iterator();
            while (!(!it.hasNext() || addToggleVisibleStateMenu && addToggleExpandStateMenu)) {
                Object first2;
                Object element = it.next();
                Object obj = null;
                if (element instanceof OrmEditPart) {
                    obj = ((OrmEditPart)element).getModel();
                } else if (element instanceof AbstractTreeEditPart) {
                    obj = ((AbstractTreeEditPart)element).getModel();
                }
                if (obj != null && obj instanceof OrmShape && ((first2 = (selectedShape = (Shape)obj).getOrmElement()) instanceof PersistentClass || first2 instanceof Table)) {
                    addToggleVisibleStateMenu = true;
                }
                if (obj == null || !(obj instanceof ExpandableShape)) continue;
                addToggleExpandStateMenu = true;
            }
            if (addToggleVisibleStateMenu) {
                action = this.getActionRegistry().getAction((Object)"toggleShapeVisibleStateId");
                this.appendToGroup(GROUP_EDIT, action);
                this.createMenuItem(this.getMenu(), action);
            }
            if (addToggleExpandStateMenu) {
                action = this.getActionRegistry().getAction((Object)"toggleShapeExpandStateId");
                this.appendToGroup(GROUP_EDIT, action);
                this.createMenuItem(this.getMenu(), action);
            }
        }
        action = this.getActionRegistry().getAction((Object)"toggleConnectionsId");
        this.appendToGroup(GROUP_EDIT, action);
        this.createMenuItem(this.getMenu(), action);
        action = this.getActionRegistry().getAction((Object)"auto_layout_id");
        this.appendToGroup(GROUP_ADDITIONAL_ACTIONS, action);
        this.createMenuItem(this.getMenu(), action);
        action = this.getActionRegistry().getAction((Object)"export_as_image_id");
        this.appendToGroup(GROUP_ADDITIONAL_ACTIONS, action);
        this.createMenuItem(this.getMenu(), action);
        menu.appendToGroup(GROUP_EDIT, this.getAction(ActionFactory.SELECT_ALL.getId()));
    }

    private IAction getAction(String actionId) {
        return this.actionRegistry.getAction((Object)actionId);
    }

    public void createMenuItem(Menu menu, IAction action) {
        boolean enabled = action.isEnabled();
        boolean hidden = false;
        if (hidden) {
            return;
        }
        MenuItem item = new MenuItem(menu, 112);
        String displayName = action.getText();
        item.addSelectionListener((SelectionListener)new AL(action));
        item.setText(displayName);
        item.setEnabled(enabled);
    }

    public ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    static class AL
    implements SelectionListener {
        IAction action;

        public AL(IAction action) {
            this.action = action;
        }

        public void widgetSelected(SelectionEvent e) {
            this.action.run();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

