/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.views.ProjectFilter;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ViewerFilter;

public class ProjectFilterAction
extends Action {
    private ViolationOverview violationView;
    private ProjectFilter projectFilter;
    private AbstractPMDRecord project;

    public ProjectFilterAction(AbstractPMDRecord abstractPMDRecord, ViolationOverview violationOverview) {
        this.violationView = violationOverview;
        this.project = abstractPMDRecord;
        ViewerFilter[] viewerFilterArray = violationOverview.getViewer().getFilters();
        int n = 0;
        while (n < viewerFilterArray.length) {
            if (viewerFilterArray[n] instanceof ProjectFilter) {
                this.projectFilter = (ProjectFilter)viewerFilterArray[n];
            }
            ++n;
        }
        this.setImageDescriptor(PMDPlugin.getImageDescriptor("icons/obj_project.gif"));
        this.setText(String.valueOf(PMDPlugin.getDefault().getStringTable().getString("view.filter.project_prefix")) + " " + abstractPMDRecord.getName());
    }

    public int getStyle() {
        return 2;
    }

    public void run() {
        if (this.isChecked()) {
            this.projectFilter.removeProjectFromList(this.project);
        } else {
            this.projectFilter.addProjectToList(this.project);
        }
        this.violationView.refresh();
    }
}

