/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.util.Iterator;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.ReviewCodeCmd;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class PMDCheckAction
implements IObjectActionDelegate {
    private static final Logger log;
    private IWorkbenchPart targetPart;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.ui.actions.PMDCheckAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.targetPart = iWorkbenchPart;
    }

    public void run(IAction iAction) {
        log.info((Object)"Check PMD action requested");
        try {
            if (this.targetPart instanceof IViewPart) {
                ISelection iSelection = this.targetPart.getSite().getSelectionProvider().getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    this.reviewSelectedResources((IStructuredSelection)iSelection);
                } else {
                    log.debug((Object)("The selection is not an instance of IStructuredSelection. This is not supported: " + iSelection.getClass().getName()));
                }
            } else if (this.targetPart instanceof IEditorPart) {
                IEditorInput iEditorInput = ((IEditorPart)this.targetPart).getEditorInput();
                if (iEditorInput instanceof IFileEditorInput) {
                    this.reviewSingleResource((IResource)((IFileEditorInput)iEditorInput).getFile());
                } else {
                    log.debug((Object)("The kind of editor input is not supported. The editor input if of type: " + iEditorInput.getClass().getName()));
                }
            } else {
                log.debug((Object)("Running PMD from this kind of part is not supported. Part is of type " + this.targetPart.getClass().getName()));
            }
        }
        catch (CommandException commandException) {
            PMDPlugin.getDefault().showError(PMDPlugin.getDefault().getStringTable().getString("message.error.core_exception"), commandException);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    private void reviewSingleResource(IResource iResource) throws CommandException {
        ReviewCodeCmd reviewCodeCmd = new ReviewCodeCmd();
        reviewCodeCmd.addResource(iResource);
        reviewCodeCmd.setStepsCount(1);
        reviewCodeCmd.setTaskMarker(true);
        reviewCodeCmd.setOpenPmdPerspective(PMDPlugin.getDefault().loadPreferences().isPmdPerspectiveEnabled());
        reviewCodeCmd.setUserInitiated(true);
        reviewCodeCmd.performExecute();
    }

    private void reviewSelectedResources(IStructuredSelection iStructuredSelection) throws CommandException {
        ReviewCodeCmd reviewCodeCmd = new ReviewCodeCmd();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            IResource iResource;
            Object e = iterator.next();
            if (e instanceof AbstractPMDRecord) {
                iResource = ((AbstractPMDRecord)e).getResource();
                if (iResource != null) {
                    reviewCodeCmd.addResource(iResource);
                    continue;
                }
                log.warn((Object)"The selected object has no resource");
                log.debug((Object)("  -> selected object : " + e));
                continue;
            }
            if (e instanceof IAdaptable) {
                IResource iResource2;
                iResource = (IAdaptable)e;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource2 = (IResource)iResource.getAdapter((Class)clazz)) != null) {
                    reviewCodeCmd.addResource(iResource2);
                    continue;
                }
                log.warn((Object)"The selected object cannot adapt to a resource");
                log.debug((Object)("   -> selected object : " + e));
                continue;
            }
            log.warn((Object)"The selected object is not adaptable");
            log.debug((Object)("   -> selected object : " + e));
        }
        reviewCodeCmd.setStepsCount(this.countElement(iStructuredSelection));
        reviewCodeCmd.setTaskMarker(true);
        reviewCodeCmd.setOpenPmdPerspective(PMDPlugin.getDefault().loadPreferences().isPmdPerspectiveEnabled());
        reviewCodeCmd.setUserInitiated(true);
        reviewCodeCmd.performExecute();
    }

    private int countElement(IStructuredSelection iStructuredSelection) {
        CountVisitor countVisitor = new CountVisitor();
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            try {
                if (e instanceof IAdaptable) {
                    IResource iResource;
                    IAdaptable iAdaptable = (IAdaptable)e;
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                        iResource.accept((IResourceVisitor)countVisitor);
                        continue;
                    }
                    log.warn((Object)"The selected object cannot adapt to a resource");
                    log.debug((Object)("   -> selected object : " + e));
                    continue;
                }
                log.warn((Object)"The selected object is not adaptable");
                log.debug((Object)("   -> selected object : " + e));
            }
            catch (CoreException coreException) {
                PMDPlugin.getDefault().logError("Exception when counting the number of impacted elements when running PMD from menu", coreException);
            }
        }
        return countVisitor.count;
    }

    private class CountVisitor
    implements IResourceVisitor {
        public int count = 0;

        private CountVisitor() {
        }

        public boolean visit(IResource iResource) {
            boolean bl = true;
            ++this.count;
            if (iResource instanceof IFile && ((IFile)iResource).getFileExtension() != null && ((IFile)iResource).getFileExtension().equals("java")) {
                bl = false;
            }
            return bl;
        }
    }
}

