/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.util.internal;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.DefaultArchiveDetector;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFileSet;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFolder;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeVisitor;
import org.jboss.ide.eclipse.archives.core.model.IArchiveStandardFileSet;
import org.jboss.ide.eclipse.archives.core.util.ModelUtil;
import org.jboss.ide.eclipse.archives.core.util.PathUtils;
import org.jboss.ide.eclipse.archives.core.util.internal.TrueZipUtil;

public class ModelTruezipBridge {
    public static FileWrapperStatusPair fullFilesetBuild(IArchiveFileSet fileset, IProgressMonitor monitor, boolean sync) {
        DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] files = fileset.findMatchingPaths();
        IStatus[] s = ModelTruezipBridge.copyFiles(fileset, files, monitor, false);
        if (sync) {
            TrueZipUtil.sync();
        }
        return new FileWrapperStatusPair(files, s);
    }

    public static FileWrapperStatusPair fullFilesetRemove(IArchiveFileSet fileset, IProgressMonitor monitor, boolean sync) {
        monitor.beginTask(ArchivesCore.bind(ArchivesCoreMessages.RemovingFileset, fileset.toString()), 2500);
        DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] files = fileset.findMatchingPaths();
        final ArrayList<Object> errors = new ArrayList<Object>();
        ArrayList<DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper> list = new ArrayList<DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper>();
        list.addAll(Arrays.asList(files));
        SubProgressMonitor filesMonitor = new SubProgressMonitor(monitor, 2000);
        filesMonitor.beginTask(ArchivesCore.bind(ArchivesCoreMessages.RemovingCountFiles, new Integer(files.length).toString()), files.length * 100);
        int i = 0;
        while (i < files.length) {
            if (!ModelUtil.otherFilesetMatchesPathAndOutputLocation(fileset, files[i])) {
                errors.addAll(Arrays.asList(ModelTruezipBridge.deleteFiles(fileset, new DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[]{files[i]}, (IProgressMonitor)new NullProgressMonitor(), false)));
            } else {
                list.remove(files[i]);
            }
            filesMonitor.worked(100);
            ++i;
        }
        filesMonitor.done();
        de.schlichtherle.io.File folder = ModelTruezipBridge.getFile(fileset);
        if (!ModelTruezipBridge.cleanFolder((File)folder, false)) {
            Status e = new Status(4, "org.jboss.ide.eclipse.archives.core", ArchivesCore.bind(ArchivesCoreMessages.ErrorEmptyingFolder, folder.toString()));
            errors.add(e);
        }
        monitor.worked(250);
        fileset.getParent().accept(new IArchiveNodeVisitor(){

            public boolean visit(IArchiveNode node) {
                boolean b = true;
                if (node.getNodeType() == 0) {
                    b = ModelTruezipBridge.createFile(node);
                } else if (node.getNodeType() == 3) {
                    b = ModelTruezipBridge.createFile(node);
                }
                if (!b) {
                    Status e = new Status(4, "org.jboss.ide.eclipse.archives.core", ArchivesCore.bind(ArchivesCoreMessages.ErrorCreatingFile, ModelTruezipBridge.getFile(node).toString()));
                    errors.add(e);
                }
                return true;
            }
        });
        if (sync) {
            TrueZipUtil.sync();
        }
        monitor.worked(250);
        monitor.done();
        IStatus[] errorsArr = errors.toArray(new IStatus[errors.size()]);
        DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] files2 = list.toArray(new DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[list.size()]);
        return new FileWrapperStatusPair(files2, errorsArr);
    }

    public static IStatus[] copyFiles(IArchiveFileSet fileset, DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] files, IProgressMonitor monitor, boolean sync) {
        monitor.beginTask(ArchivesCore.bind(ArchivesCoreMessages.CopyingCountFiles, new Integer(files.length).toString()), files.length * 100);
        boolean b = true;
        ArrayList<Status> list = new ArrayList<Status>();
        de.schlichtherle.io.File[] destFiles = ModelTruezipBridge.getFiles(files, fileset);
        int i = 0;
        while (i < files.length) {
            b = TrueZipUtil.copyFile(files[i].getAbsolutePath(), destFiles[i]);
            if (!b) {
                list.add(new Status(4, "org.jboss.ide.eclipse.archives.core", ArchivesCore.bind(ArchivesCoreMessages.FileCopyFailed, files[i].getAbsolutePath(), destFiles[i].toString())));
            }
            monitor.worked(100);
            ++i;
        }
        if (sync) {
            TrueZipUtil.sync();
        }
        monitor.done();
        return list.toArray(new IStatus[list.size()]);
    }

    public static IStatus[] deleteFiles(IArchiveFileSet fileset, DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] files, IProgressMonitor monitor, boolean sync) {
        monitor.beginTask(ArchivesCore.bind(ArchivesCoreMessages.DeletingCountFiles, new Integer(files.length).toString()), files.length * 100);
        de.schlichtherle.io.File[] destFiles = ModelTruezipBridge.getFiles(files, fileset);
        ArrayList<Status> list = new ArrayList<Status>();
        int i = 0;
        while (i < files.length) {
            if (!TrueZipUtil.deleteAll(destFiles[i])) {
                Status e = new Status(4, "org.jboss.ide.eclipse.archives.core", ArchivesCore.bind(ArchivesCoreMessages.FileDeleteFailed, destFiles[i].toString()));
                list.add(e);
            }
            monitor.worked(100);
            ++i;
        }
        if (sync) {
            TrueZipUtil.sync();
        }
        monitor.done();
        return list.toArray(new IStatus[list.size()]);
    }

    public static boolean deleteArchive(IArchive archive) {
        de.schlichtherle.io.File file = ModelTruezipBridge.getFile(archive);
        boolean b = file.deleteAll();
        TrueZipUtil.sync();
        return b;
    }

    public static boolean cleanFolder(IArchiveFolder folder) {
        return ModelTruezipBridge.cleanFolder((File)ModelTruezipBridge.getFile(folder), true);
    }

    public static boolean cleanFolder(File folder, boolean sync) {
        boolean b = TrueZipUtil.deleteEmptyChildren(folder);
        if (sync) {
            TrueZipUtil.sync();
        }
        return b;
    }

    public static boolean createFile(IArchiveNode node) {
        return ModelTruezipBridge.createFile(node, true);
    }

    public static boolean createFile(IArchiveNode node, boolean sync) {
        de.schlichtherle.io.File f = ModelTruezipBridge.getFile(node);
        if (f == null) {
            return false;
        }
        if (f.exists()) {
            return true;
        }
        boolean b = f.mkdirs();
        if (sync) {
            TrueZipUtil.sync();
        }
        return b;
    }

    private static de.schlichtherle.io.File[] getFiles(DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] inputFiles, IArchiveFileSet fs) {
        de.schlichtherle.io.File fsFile = ModelTruezipBridge.getFile(fs);
        if (fs == null || fsFile == null) {
            return new de.schlichtherle.io.File[0];
        }
        ArrayList<de.schlichtherle.io.File> returnFiles = new ArrayList<de.schlichtherle.io.File>();
        int i = 0;
        while (i < inputFiles.length) {
            if (inputFiles[i] != null) {
                de.schlichtherle.io.File parentFile;
                String filesetRelative = fs instanceof IArchiveStandardFileSet && ((IArchiveStandardFileSet)fs).isFlattened() ? inputFiles[i].getOutputName() : inputFiles[i].getFilesetRelative();
                if (new Path(filesetRelative).segmentCount() > 1) {
                    String tmp = new Path(filesetRelative).removeLastSegments(1).toString();
                    parentFile = new de.schlichtherle.io.File((File)fsFile, tmp, (ArchiveDetector)ArchiveDetector.NULL);
                    if (parentFile.getEnclArchive() != null) {
                        parentFile = new de.schlichtherle.io.File((File)fsFile, tmp, (ArchiveDetector)ArchiveDetector.DEFAULT);
                    }
                } else {
                    parentFile = fsFile;
                }
                returnFiles.add(new de.schlichtherle.io.File((File)parentFile, new Path(filesetRelative).lastSegment(), (ArchiveDetector)ArchiveDetector.NULL));
            }
            ++i;
        }
        return returnFiles.toArray(new de.schlichtherle.io.File[returnFiles.size()]);
    }

    private static de.schlichtherle.io.File getFile(IArchiveNode node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == -1) {
            return null;
        }
        if (node.getNodeType() == 2) {
            return ModelTruezipBridge.getFile(node.getParent());
        }
        de.schlichtherle.io.File parentFile = ModelTruezipBridge.getFile(node.getParent());
        if (node.getNodeType() == 0) {
            DefaultArchiveDetector detector;
            IArchive node2 = (IArchive)node;
            boolean exploded = ((IArchive)node).isExploded();
            Object object = detector = exploded ? ArchiveDetector.NULL : TrueZipUtil.getJarArchiveDetector();
            if (parentFile == null) {
                IPath p = PathUtils.getGlobalLocation(node2);
                if (p == null) {
                    return null;
                }
                parentFile = new de.schlichtherle.io.File(p.toOSString(), (ArchiveDetector)ArchiveDetector.NULL);
            }
            return new de.schlichtherle.io.File((File)parentFile, node2.getName(), (ArchiveDetector)detector);
        }
        if (node.getNodeType() == 3) {
            return new de.schlichtherle.io.File((File)parentFile, ((IArchiveFolder)node).getName(), (ArchiveDetector)ArchiveDetector.NULL);
        }
        return null;
    }

    public static String getFilePath(IArchiveNode node) {
        de.schlichtherle.io.File f = ModelTruezipBridge.getFile(node);
        return f == null ? null : f.getAbsolutePath();
    }

    public static class FileWrapperStatusPair {
        public DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] f;
        public IStatus[] s;

        public FileWrapperStatusPair(DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] files, IStatus[] statuses) {
            this.f = files;
            this.s = statuses;
        }
    }
}

