/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.DialogSelectionHelper;
import org.hibernate.eclipse.console.utils.DriverClassHelpers;
import org.hibernate.eclipse.launch.ConsoleConfigurationTab;
import org.xml.sax.EntityResolver;

public class ConsoleConfigurationOptionsTab
extends ConsoleConfigurationTab {
    private Combo dialectNameCombo;
    private Text entityResolverClassNameText;
    private Text namingStrategyClassNameText;
    private DriverClassHelpers helper = new DriverClassHelpers();

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        comp.setLayout((Layout)layout);
        comp.setFont(font);
        this.createDialectNameCombo(comp);
        this.createNamingStrategyClassNameEditor(comp);
        this.createEntityResolverClassNameEditor(comp);
    }

    private void createDialectNameCombo(Composite parent) {
        Group group = this.createGroup(parent, HibernateConsoleMessages.NewConfigurationWizardPage_database_dialect);
        this.dialectNameCombo = new Combo((Composite)group, 0);
        this.dialectNameCombo.setItems(this.helper.getDialectNames());
        Font font = parent.getFont();
        GridData gd = new GridData(768);
        this.dialectNameCombo.setLayoutData((Object)gd);
        this.dialectNameCombo.setFont(font);
        this.dialectNameCombo.addModifyListener((ModifyListener)this.getChangeListener());
    }

    private void createNamingStrategyClassNameEditor(Composite parent) {
        Group group = this.createGroup(parent, HibernateConsoleMessages.ConsoleConfigurationOptionsTab_naming_strategy);
        this.namingStrategyClassNameText = this.createBrowseEditor(parent, group);
        this.createBrowseButton(group, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationOptionsTab.this.handleNamingStrategyBrowse();
            }
        });
    }

    private void createEntityResolverClassNameEditor(Composite parent) {
        Group group = this.createGroup(parent, HibernateConsoleMessages.ConsoleConfigurationOptionsTab_entity_resolver);
        this.entityResolverClassNameText = this.createBrowseEditor(parent, group);
        this.createBrowseButton(group, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfigurationOptionsTab.this.handleEntityResolverBrowse();
            }
        });
    }

    public String getName() {
        return HibernateConsoleMessages.ConsoleConfigurationOptionsTab_options;
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_OBJS_COMMON_TAB");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String dialect = configuration.getAttribute("org.hibernate.eclipse.launchDIALECT", "");
            this.dialectNameCombo.setText(this.helper.getShortDialectName(dialect));
            this.namingStrategyClassNameText.setText(configuration.getAttribute("org.hibernate.eclipse.launchNAMING_STRATEGY", ""));
            this.entityResolverClassNameText.setText(configuration.getAttribute("org.hibernate.eclipse.launchENTITY_RESOLVER", ""));
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String dialect = this.nonEmptyTrimOrNull(this.dialectNameCombo.getText());
        dialect = this.helper.getDialectClass(dialect);
        configuration.setAttribute("org.hibernate.eclipse.launchDIALECT", this.nonEmptyTrimOrNull(dialect));
        configuration.setAttribute("org.hibernate.eclipse.launchNAMING_STRATEGY", this.nonEmptyTrimOrNull(this.namingStrategyClassNameText));
        configuration.setAttribute("org.hibernate.eclipse.launchENTITY_RESOLVER", this.nonEmptyTrimOrNull(this.entityResolverClassNameText));
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private void handleEntityResolverBrowse() {
        String string = DialogSelectionHelper.chooseImplementation(EntityResolver.class.getName(), this.entityResolverClassNameText.getText(), HibernateConsoleMessages.ConsoleConfigurationOptionsTab_select_entity_resolver_class, this.getShell());
        if (string != null) {
            this.entityResolverClassNameText.setText(string);
        }
    }

    private void handleNamingStrategyBrowse() {
        String string = DialogSelectionHelper.chooseImplementation(NamingStrategy.class.getName(), this.namingStrategyClassNameText.getText(), HibernateConsoleMessages.ConsoleConfigurationOptionsTab_select_naming_strategy_class, this.getShell());
        if (string != null) {
            this.namingStrategyClassNameText.setText(string);
        }
    }
}

