/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.DialogSelectionHelper;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.wizards.UpDownListComposite;
import org.hibernate.eclipse.launch.ConsoleConfigurationTab;

public class ConsoleConfigurationMappingsTab
extends ConsoleConfigurationTab {
    private UpDownListComposite mappingFilesViewer;

    public void createControl(Composite parent) {
        UpDownListComposite composite = this.buildMappingFileTable(parent);
        this.setControl((Control)composite);
    }

    private UpDownListComposite buildMappingFileTable(Composite parent) {
        this.mappingFilesViewer = new UpDownListComposite(parent, 0, HibernateConsoleMessages.ConsoleConfigurationMappingsTab_additional_mapping_files){

            protected Object[] handleAdd(int idx) {
                TableItem[] items = this.getTable().getItems();
                IPath[] exclude = new IPath[items.length];
                int i = 0;
                while (i < items.length) {
                    TableItem item = items[i];
                    exclude[i] = (IPath)item.getData();
                    ++i;
                }
                return DialogSelectionHelper.chooseFileEntries(this.getShell(), null, exclude, HibernateConsoleMessages.ConsoleConfigurationMappingsTab_add_hbm_xml_file, HibernateConsoleMessages.ConsoleConfigurationMappingsTab_add_hibernate_mapping_file, new String[]{"hbm.xml"}, true, false, true);
            }

            protected void listChanged() {
                ConsoleConfigurationMappingsTab.this.updateLaunchConfigurationDialog();
            }
        };
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 3;
        gd.verticalSpan = 1;
        this.mappingFilesViewer.setLayoutData(gd);
        return this.mappingFilesViewer;
    }

    public String getName() {
        return HibernateConsoleMessages.ConsoleConfigurationMappingsTab_mappings;
    }

    private IPath[] getMappings() {
        Table table = this.mappingFilesViewer.getTable();
        TableItem[] items = table.getItems();
        IPath[] str = new IPath[items.length];
        int i = 0;
        while (i < items.length) {
            IPath path;
            TableItem item = items[i];
            str[i] = path = (IPath)item.getData();
            ++i;
        }
        return str;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.mappingFilesViewer.clear();
            List mappings = configuration.getAttribute("org.hibernate.eclipse.launch.FILE_MAPPINGS", Collections.EMPTY_LIST);
            Object[] mapA = new IPath[mappings.size()];
            int i = 0;
            for (String file : mappings) {
                mapA[i++] = Path.fromPortableString((String)file);
            }
            this.mappingFilesViewer.add(mapA, false);
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        IPath[] mappings = this.getMappings();
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < mappings.length) {
            IPath path = mappings[i];
            l.add(path.toPortableString());
            ++i;
        }
        configuration.setAttribute("org.hibernate.eclipse.launch.FILE_MAPPINGS", l);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public Image getImage() {
        return EclipseImages.getImage("MAPPEDCLASS");
    }
}

