/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.hibernate.SessionFactory;
import org.hibernate.console.ConcoleConfigurationAdapter;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.ConsoleConfigurationListener;
import org.hibernate.console.ConsoleMessages;
import org.hibernate.console.ConsoleQueryParameter;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.KnownConfigurationsListener;
import org.hibernate.console.QueryPage;
import org.hibernate.console.QueryPageModel;
import org.hibernate.console.node.BaseNode;
import org.hibernate.console.node.ConfigurationListNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnownConfigurations {
    private QueryPageModel queryPages = new QueryPageModel();
    private List<KnownConfigurationsListener> configurationListeners = new ArrayList<KnownConfigurationsListener>();
    private Map<String, ConsoleConfiguration> configurations;
    private ConsoleConfigurationListener sfListener = new ConcoleConfigurationAdapter(){

        public void sessionFactoryClosing(final ConsoleConfiguration configuration, final SessionFactory closingFactory) {
            KnownConfigurations.this.fireNotification(new Notification(KnownConfigurations.this){

                public void notify(KnownConfigurationsListener listener) {
                    listener.sessionFactoryClosing(configuration, closingFactory);
                }
            });
        }

        public void sessionFactoryBuilt(final ConsoleConfiguration ccfg, final SessionFactory builtSessionFactory) {
            KnownConfigurations.this.fireNotification(new Notification(KnownConfigurations.this){

                public void notify(KnownConfigurationsListener listener) {
                    listener.sessionFactoryBuilt(ccfg, builtSessionFactory);
                }
            });
        }

        public void queryPageCreated(QueryPage qp) {
            KnownConfigurations.this.queryPages.add(qp);
        }

        public void configurationBuilt(final ConsoleConfiguration ccfg) {
            KnownConfigurations.this.fireNotification(new Notification(KnownConfigurations.this){

                public void notify(KnownConfigurationsListener listener) {
                    listener.configurationBuilt(ccfg);
                }
            });
        }

        public void configurationReset(final ConsoleConfiguration ccfg) {
            KnownConfigurations.this.fireNotification(new Notification(KnownConfigurations.this){

                public void notify(KnownConfigurationsListener listener) {
                    listener.configurationReset(ccfg);
                }
            });
        }
    };
    private static KnownConfigurations instance;
    BaseNode rootNode = new ConfigurationListNode(this);
    private Map<String, Object[]> loggingStreams = new HashMap<String, Object[]>();
    List<ConsoleQueryParameter> queryParameters = new ArrayList<ConsoleQueryParameter>();

    public static synchronized KnownConfigurations getInstance() {
        if (instance == null) {
            instance = new KnownConfigurations();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsoleConfigurationListener(KnownConfigurationsListener listener) {
        List<KnownConfigurationsListener> list = this.configurationListeners;
        synchronized (list) {
            this.configurationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigurationListener(KnownConfigurationsListener listener) {
        List<KnownConfigurationsListener> list = this.configurationListeners;
        synchronized (list) {
            this.configurationListeners.remove(listener);
        }
    }

    public ConsoleConfiguration addConfiguration(final ConsoleConfiguration configuration, boolean broadcast) {
        ConsoleConfiguration existingConfiguration = this.internalGetRepository(configuration.getName());
        if (existingConfiguration == null) {
            this.getRepositoriesMap().put(configuration.getName(), configuration);
            configuration.addConsoleConfigurationListener(this.sfListener);
            existingConfiguration = configuration;
        }
        if (broadcast) {
            this.fireNotification(new Notification(){

                public void notify(KnownConfigurationsListener listener) {
                    listener.configurationAdded(configuration);
                }
            });
        }
        return existingConfiguration;
    }

    public void removeAllConfigurations() {
        ConsoleConfiguration[] cfgs = this.getConfigurations();
        int i = 0;
        while (i < cfgs.length) {
            ConsoleConfiguration configuration = cfgs[i];
            this.removeConfiguration(configuration, false);
            ++i;
        }
    }

    public void removeConfiguration(final ConsoleConfiguration configuration, final boolean forUpdate) {
        ConsoleConfiguration oldConfig = this.getRepositoriesMap().remove(configuration.getName());
        if (oldConfig != null) {
            oldConfig.removeConsoleConfigurationListener(this.sfListener);
            this.fireNotification(new Notification(){

                public void notify(KnownConfigurationsListener listener) {
                    listener.configurationRemoved(configuration, forUpdate);
                }
            });
            oldConfig.reset();
            this.removeLoggingStream(oldConfig);
        }
    }

    public boolean isKnownConfiguration(String name) {
        return this.internalGetRepository(name) != null;
    }

    public ConsoleConfiguration[] getConfigurations() {
        return this.getRepositoriesMap().values().toArray(new ConsoleConfiguration[this.getRepositoriesMap().size()]);
    }

    public ConsoleConfiguration[] getConfigurationsSortedByName() {
        return this.getConfigurations(new Comparator<ConsoleConfiguration>(){

            @Override
            public int compare(ConsoleConfiguration o1, ConsoleConfiguration o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
    }

    public ConsoleConfiguration[] getConfigurations(Comparator<ConsoleConfiguration> c) {
        ConsoleConfiguration[] configurations = this.getConfigurations();
        Arrays.sort(configurations, c);
        return configurations;
    }

    private ConsoleConfiguration internalGetRepository(String location) {
        return this.getRepositoriesMap().get(location);
    }

    private Map<String, ConsoleConfiguration> getRepositoriesMap() {
        if (this.configurations == null) {
            this.configurations = new TreeMap<String, ConsoleConfiguration>();
        }
        return this.configurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KnownConfigurationsListener[] getListeners() {
        List<KnownConfigurationsListener> list = this.configurationListeners;
        synchronized (list) {
            return this.configurationListeners.toArray(new KnownConfigurationsListener[this.configurationListeners.size()]);
        }
    }

    private void fireNotification(Notification notification) {
        KnownConfigurationsListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            KnownConfigurationsListener listener = listeners[i];
            notification.run(listener);
            ++i;
        }
    }

    public BaseNode getRootNode() {
        return this.rootNode;
    }

    public MessageConsoleStream findLoggingStream(String name) {
        Object[] console = this.loggingStreams.get(name);
        if (console == null) {
            console = new Object[2];
            String secondaryId = String.valueOf(ConsoleMessages.KnownConfigurations_hibernate_log) + (name == null ? ConsoleMessages.KnownConfigurations_unknown : name);
            console[0] = new MessageConsole(secondaryId, null);
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            consoleManager.addConsoles(new IConsole[]{(IConsole)console[0]});
            console[1] = ((MessageConsole)console[0]).newMessageStream();
            this.loggingStreams.put(name, console);
        }
        return (MessageConsoleStream)console[1];
    }

    private void removeLoggingStream(ConsoleConfiguration oldConfig) {
        Object[] object = this.loggingStreams.remove(oldConfig.getName());
        if (object != null) {
            MessageConsole mc = (MessageConsole)object[0];
            MessageConsoleStream stream = (MessageConsoleStream)object[1];
            try {
                stream.close();
            }
            catch (IOException iOException) {}
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            consoleManager.removeConsoles(new IConsole[]{mc});
        }
    }

    public ConsoleConfiguration find(String lastUsedName) {
        if (this.configurations == null) {
            return null;
        }
        if (lastUsedName == null) {
            return null;
        }
        return this.configurations.get(lastUsedName);
    }

    public QueryPageModel getQueryPageModel() {
        return this.queryPages;
    }

    public void writeStateTo(File f) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element element = document.createElement("hibernate-console");
            document.appendChild(element);
            ConsoleConfiguration[] configs = this.getConfigurations();
            int i = 0;
            while (i < configs.length) {
                ConsoleConfiguration cfg = configs[i];
                cfg.getPreferences().writeStateTo(element);
                ++i;
            }
            this.writeXml(document, f);
        }
        catch (TransformerConfigurationException e) {
            throw new HibernateConsoleRuntimeException(ConsoleMessages.KnownConfigurations_could_not_write_state, e);
        }
        catch (TransformerException e) {
            throw new HibernateConsoleRuntimeException(ConsoleMessages.KnownConfigurations_could_not_write_state, e);
        }
        catch (ParserConfigurationException e) {
            throw new HibernateConsoleRuntimeException(ConsoleMessages.KnownConfigurations_could_not_write_state, e);
        }
    }

    private void writeXml(Document document, File f) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(f);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.setOutputProperty("indent", "true");
        xformer.transform(source, result);
    }

    public ConsoleQueryParameter[] getQueryParameters() {
        return this.queryParameters.toArray(new ConsoleQueryParameter[this.queryParameters.size()]);
    }

    public List<ConsoleQueryParameter> getQueryParameterList() {
        return this.queryParameters;
    }

    private abstract class Notification {
        private Notification() {
        }

        public void run(KnownConfigurationsListener listener) {
            this.notify(listener);
        }

        protected abstract void notify(KnownConfigurationsListener var1);
    }
}

