/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.propertieseditor;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.bundle.CountriesHelper;
import org.jboss.tools.common.model.ui.ModelUIMessages;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.CommandBarLayout;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.propertieseditor.BundleLocaleEditor;
import org.jboss.tools.common.propertieseditor.DefaultComboModel;
import org.jboss.tools.common.propertieseditor.bundlemodel.BundleModel;

public class BundleLanguagesEditor
implements CommandBarListener,
SelectionListener {
    static String CREATE = ModelUIMessages.BundleLanguagesEditor_Add;
    static String DELETE = ModelUIMessages.BundleLanguagesEditor_Delete;
    public Image IMAGE_DELETE = EclipseResourceUtil.getImage((String)"images/actions/delete.gif");
    public Image IMAGE_EDIT = EclipseResourceUtil.getImage((String)"images/actions/edit.gif");
    public Image IMAGE_CREATE = EclipseResourceUtil.getImage((String)"images/actions/new.gif");
    BundleModel bundleModel;
    protected Composite control;
    protected ComboModel combomodel = new ComboModel();
    protected Combo combo;
    protected CommandBar bar = this.createBar();
    BundleLocaleEditor listener;
    boolean lock = false;

    public void dispose() {
        this.listener = null;
        if (this.combomodel != null) {
            this.combomodel.dispose();
        }
        this.combomodel = null;
        if (this.bar != null) {
            this.bar.dispose();
        }
        this.bar = null;
    }

    public void setBundleModel(BundleModel bundleModel) {
        this.bundleModel = bundleModel;
    }

    public void addListener(BundleLocaleEditor listener) {
        this.listener = listener;
    }

    public Control createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setLayout((Layout)new GridLayout(2, false));
        this.createComboControl(this.control);
        this.bar.createControl(this.control);
        return this.control;
    }

    private Control createComboControl(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(control, 0);
        label.setText(ModelUIMessages.BundleLanguagesEditor_LanguageCountry);
        this.combo = new Combo(control, 12);
        this.combomodel.setCombo(this.combo);
        this.update();
        this.combo.addSelectionListener((SelectionListener)this);
        return control;
    }

    private CommandBar createBar() {
        CommandBar c = new CommandBar();
        CommandBarLayout layout = c.getLayout();
        layout.iconsOnly = true;
        layout.asToolBar = true;
        c.setCommands(new String[]{CREATE, DELETE});
        c.setEnabled(CREATE, true);
        c.setEnabled(DELETE, true);
        c.addCommandBarListener(this);
        c.setImage(CREATE, this.IMAGE_CREATE);
        c.setImage(DELETE, this.IMAGE_DELETE);
        return c;
    }

    public Control getControl() {
        return this.control;
    }

    public void update() {
        if (this.combo == null || this.combo.isDisposed()) {
            return;
        }
        if (this.lock) {
            return;
        }
        this.lock = true;
        Object[] ls = this.bundleModel.getLocales();
        String lc = this.bundleModel.getCurrentLocale();
        if (this.isChanged(ls, this.combomodel)) {
            this.setBoxValues(ls, this.combomodel, lc);
        } else {
            this.combomodel.refresh();
        }
        this.control.getParent().update();
        this.control.redraw();
        this.lock = false;
    }

    private boolean isChanged(Object[] vs, ComboModel combomodel) {
        if (combomodel.getSize() != vs.length) {
            return true;
        }
        int i = 0;
        while (i < vs.length) {
            if (vs[i] != combomodel.getElementAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Object setBoxValues(Object[] vs, ComboModel combomodel, Object selected) {
        boolean e = false;
        combomodel.removeAllElements();
        int i = 0;
        while (i < vs.length) {
            if (vs[i] == selected) {
                e = true;
            }
            combomodel.addElement(vs[i]);
            ++i;
        }
        if (!e) {
            Object object = selected = vs.length > 0 ? vs[0] : null;
        }
        if (selected != null) {
            combomodel.setSelectedItem(selected);
        }
        return selected;
    }

    public void action(String command) {
        if (CREATE.equals(command)) {
            this.add();
        } else if (DELETE.equals(command)) {
            this.delete();
        }
    }

    private void add() {
        CountriesHelper.init((XModel)this.bundleModel.getModelObject().getModel());
        XModelObject o = this.bundleModel.getModelObject().getModel().createModelObject("BundleList", null);
        XActionInvoker.invoke((String)"CreateActions.AddBundle", (XModelObject)o, null);
        XModelObject[] os = o.getChildren();
        if (os.length == 0) {
            return;
        }
        String lg = os[0].getAttributeValue("language");
        String ct = os[0].getAttributeValue("country");
        String locale = (String.valueOf(lg) + ct).length() == 0 ? "" : String.valueOf(lg) + "_" + ct;
        this.bundleModel.addLocale(locale);
        this.update();
        this.widgetSelected(null);
    }

    private void delete() {
        int i = this.combo.getSelectionIndex();
        Object o = this.combomodel.getSelectedItem();
        if (o == null) {
            return;
        }
        this.bundleModel.removeLocale(o.toString());
        String[] is = this.bundleModel.getLocales();
        if (is.length <= i) {
            i = is.length - 1;
        }
        if (i >= 0) {
            this.bundleModel.setCurrentLocale(is[i]);
        }
        this.update();
        this.widgetSelected(null);
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.lock) {
            return;
        }
        Object o = this.combomodel.getSelectedItem();
        String locale = o == null ? "" : o.toString();
        this.bundleModel.setCurrentLocale(locale);
        if (this.listener != null) {
            this.listener.update();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    class ComboModel
    extends DefaultComboModel {
        ComboModel() {
        }

        public String getPresentation(Object object) {
            String s = super.getPresentation(object);
            return s.length() == 0 ? "default" : s;
        }
    }
}

