/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.widgets;

import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.model.ui.widgets.Line;
import org.jboss.tools.common.model.ui.widgets.ReferenceListener;
import org.jboss.tools.common.model.ui.widgets.Token;
import org.jboss.tools.common.model.ui.widgets.Tokenizer;

public class TextAndReferenceComponent
extends Canvas
implements PaintListener,
MouseMoveListener {
    int defaultWidth = 100;
    int width;
    String text = "";
    Line[] lines = new Line[0];
    int lineHeight = 12;
    ReferenceListener listener;
    Font plain;
    Font bold;
    Token[] tokens = new Token[0];

    public TextAndReferenceComponent(Composite parent, int style) {
        super(parent, style);
        this.addPaintListener(this);
        this.addMouseMoveListener(this);
        this.addMouseListener((MouseListener)new MA());
        this.plain = this.getFont();
        FontData d = this.plain.getFontData()[0];
        this.bold = new Font(null, d.getName(), d.getHeight(), d.getStyle() | 1);
    }

    public void mouseMove(MouseEvent e) {
        int c = this.overReference(e.x, e.y) ? 21 : 0;
        this.setCursor(new Cursor((Device)Display.getCurrent(), c));
    }

    private boolean overReference(int x, int y) {
        Token t = this.findToken(x, y);
        return t != null && t.isReference;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.width = wHint == -1 ? this.defaultWidth : wHint;
        GC g = new GC((Drawable)this);
        g.setFont(this.getFont());
        this.lines = Tokenizer.breakIntoLines(g, this.tokens, this.width);
        return new Point(this.width + 10, this.lines.length * this.lineHeight + 6);
    }

    public int getStringWidth(Font font, String str) {
        GC g = new GC((Drawable)this);
        int size = TextAndReferenceComponent.getStringWidth(g, font, str);
        g.dispose();
        return size;
    }

    public static int getStringWidth(GC g, Font font, String str) {
        int size = 0;
        g.setFont(font);
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            size += g.getCharWidth(c) + 1;
            if (c == ' ') {
                ++size;
            }
            ++i;
        }
        return size;
    }

    public void setText(String text, int width) {
        this.text = text;
        this.defaultWidth = width;
        this.width = width;
        this.tokens = Tokenizer.tokenize(text, this.plain, this.bold);
        this.pack();
    }

    public void paintControl(PaintEvent ev) {
        if (this.lines.length == 0) {
            return;
        }
        GC g = ev.gc;
        Font f = this.getFont();
        g.setFont(f);
        int i = 0;
        while (i < this.lines.length) {
            int y = 2 + i * this.lineHeight;
            this.lines[i].paint(this.tokens, g, y);
            ++i;
        }
    }

    public void addReferenceListener(ReferenceListener listener) {
        this.listener = listener;
    }

    Token findToken(int x, int y) {
        int i = 0;
        while (i < this.tokens.length) {
            if (this.tokens[i].contains(x, y)) {
                return this.tokens[i];
            }
            ++i;
        }
        return null;
    }

    class MA
    extends MouseAdapter {
        MA() {
        }

        public void mouseDown(MouseEvent e) {
            Token t = TextAndReferenceComponent.this.findToken(e.x, e.y);
            if (t != null && TextAndReferenceComponent.this.listener != null && t.isReference) {
                TextAndReferenceComponent.this.listener.referenceSelected(t.text);
            }
        }
    }
}

