/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.palette;

import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jboss.tools.common.model.ui.views.palette.model.IPaletteNode;

public class PaletteDescriptionManager
extends AbstractHoverInformationControlManager {
    private ToolBar fToolBar = null;
    private boolean fWindowsFlag;

    public PaletteDescriptionManager() {
        super((IInformationControlCreator)new DescriptionControlCreator());
        this.setSizeConstraints(60, 30, false, false);
        this.fWindowsFlag = true;
        String osName = System.getProperty("os.name");
        this.fWindowsFlag = osName != null && osName.toUpperCase().indexOf("WINDOWS") != -1;
    }

    protected void computeInformation() {
        if (this.fToolBar != null) {
            ToolItem item = this.fToolBar.getItem(0);
            Rectangle barArea = this.fToolBar.getBounds();
            Rectangle itemArea = item.getBounds();
            Rectangle area = new Rectangle(barArea.x + itemArea.x, barArea.y + itemArea.y, itemArea.width, itemArea.height);
            IPaletteNode node = (IPaletteNode)item.getData();
            String description = node.getDescription();
            this.setInformation(description, area);
        } else {
            this.setInformation(null, null);
        }
    }

    private static class DescriptionControlCreator
    implements IInformationControlCreator {
        private DescriptionControlCreator() {
        }

        public IInformationControl createInformationControl(Shell parent) {
            return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
        }
    }
}

