/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.jboss.tools.common.MethodNotImplementedException;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class CheckBoxFieldEditor
extends ExtendedFieldEditor
implements IFieldEditor,
IPropertyFieldEditor,
IPropertyChangeListener,
PropertyChangeListener {
    public static final int DEFAULT = 0;
    public static final int SEPARATE_LABEL = 1;
    public static final int SKIP_LABEL = 2;
    private int style = 2;
    private Button checkBox = null;
    protected String trueValue = "true";
    protected String falseValue = "false";
    protected boolean booleanValue = false;
    protected IPropertyEditor propertyEditor;
    protected IValueProvider valueProvider;
    protected IValueChangeListener valueChangeListener;

    public CheckBoxFieldEditor() {
    }

    public CheckBoxFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    protected void adjustForNumColumns(int numColumns) {
        if (this.style == 1) {
            --numColumns;
        }
        if (this.style == 2) {
            --numColumns;
        }
        ((GridData)this.checkBox.getLayoutData()).horizontalSpan = numColumns;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        String text = this.getLabelText();
        if (this.style == 2) {
            Label label = new Label(parent, 0);
            label.setText("");
            --numColumns;
        }
        if (this.style == 1) {
            this.getLabelComposite(parent);
            --numColumns;
            text = null;
        }
        this.checkBox = this.createChangeControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        this.checkBox.setLayoutData((Object)gd);
        if (text != null) {
            this.checkBox.setText(text);
        }
    }

    protected Control createCheckBoxLabelControl(Composite parent) {
        Button checkBox = this.createChangeControl(parent);
        if (this.getLabelText() != null) {
            checkBox.setText(this.getLabelText());
        }
        return checkBox;
    }

    protected void doLoad() {
        throw new MethodNotImplementedException();
    }

    protected void doLoadDefault() {
        throw new MethodNotImplementedException();
    }

    protected void doStore() {
    }

    protected Button createChangeControl(Composite parent) {
        if (this.checkBox != null) {
            this.checkParent((Control)this.checkBox, parent);
            return this.checkBox;
        }
        int style = 0;
        if (this.getSettings() != null) {
            style = this.getSettings().getStyle("CheckBox.Style");
        }
        if (style == -1) {
            style = 16416;
        }
        this.checkBox = new Button(parent, style);
        this.checkBox.setFont(parent.getFont());
        this.createSelectionListener();
        this.createDisposeListener();
        this.checkBox.setSelection(this.booleanValue);
        return this.checkBox;
    }

    private void createSelectionListener() {
        this.checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = CheckBoxFieldEditor.this.checkBox.getSelection();
                CheckBoxFieldEditor.this.valueChanged(CheckBoxFieldEditor.this.booleanValue, isSelected);
                CheckBoxFieldEditor.this.booleanValue = isSelected;
            }
        });
    }

    private void createDisposeListener() {
        this.checkBox.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                CheckBoxFieldEditor.this.checkBox = null;
            }
        });
    }

    public int getNumberOfControls() {
        return this.style == 2 || this.style == 1 ? 2 : 1;
    }

    public void setFocus() {
        if (this.checkBox != null) {
            this.checkBox.setFocus();
        }
    }

    public void setLabelText(String text) {
        super.setLabelText(text);
        Control label = this.getLabelComposite();
        if (label == null && this.checkBox != null) {
            this.checkBox.setText(text);
        }
    }

    protected void valueChanged(boolean oldValue, boolean newValue) {
        this.setPresentsDefaultValue(false);
        if (oldValue != newValue) {
            this.fireStateChanged("field_editor_value", oldValue, newValue);
        }
    }

    public Control getChangeControl() {
        return this.checkBox;
    }

    public void setEnabled(boolean enabled) {
        if (this.style == 1) {
            super.setEnabled(enabled);
        }
        if (this.getChangeControl() != null) {
            this.getChangeControl().setEnabled(enabled);
        }
    }

    public void setBooleanValue(boolean isChecked) {
        boolean oldValue;
        this.booleanValue = isChecked;
        if (this.checkBox != null && (oldValue = this.checkBox.getSelection()) != this.booleanValue) {
            this.checkBox.setSelection(this.booleanValue);
            this.valueChanged(oldValue, this.booleanValue);
        }
    }

    public boolean getBooleanValue() {
        if (this.checkBox != null) {
            return this.checkBox.getSelection();
        }
        return this.getPreferenceStore().getBoolean(this.getPreferenceName());
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    private void initValue(Object value) {
        if (value instanceof String && ("yes".equalsIgnoreCase(value.toString()) || "no".equalsIgnoreCase(value.toString()))) {
            this.trueValue = "yes";
            this.falseValue = "no";
        }
    }

    private boolean isTrue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return value instanceof String && ("yes".equalsIgnoreCase(value.toString()) || "true".equalsIgnoreCase(value.toString()));
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("field_editor_value".equals(e.getProperty())) {
            this.setPropertyChangeListener(null);
            boolean newBooleanValue = (Boolean)e.getNewValue();
            boolean oldBooleanValue = (Boolean)e.getOldValue();
            String oldValue = oldBooleanValue ? this.trueValue : this.falseValue;
            String newValue = newBooleanValue ? this.trueValue : this.falseValue;
            java.beans.PropertyChangeEvent event = new java.beans.PropertyChangeEvent(this, "field_editor_value", oldValue, newValue);
            this.valueChangeListener.valueChange(event);
            this.setPropertyChangeListener(this);
        }
    }

    protected void init() {
        this.initValue(this.valueProvider.getValue());
        this.setBooleanValue(this.isTrue(this.valueProvider.getValue()));
        this.setPropertyChangeListener(this);
        this.valueProvider.addValueChangeListener(this);
    }

    public void dispose() {
        super.dispose();
        if (this.checkBox != null && !this.checkBox.isDisposed()) {
            this.checkBox.dispose();
        }
        if (this.valueProvider != null) {
            this.valueProvider.removeValueChangeListener(this);
        }
        this.checkBox = null;
        this.propertyEditor = null;
        this.valueProvider = null;
        this.valueChangeListener = null;
    }

    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
        }
        this.init();
    }

    public Control[] getControls(Composite parent) {
        return new Control[]{new Label(parent, 0), this.createCheckBoxLabelControl(parent)};
    }

    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        this.valueProvider.removeValueChangeListener(this);
        this.setBooleanValue(this.isTrue(evt.getNewValue()));
        this.valueProvider.addValueChangeListener(this);
    }

    public void setIndent(int width) {
        if (this.checkBox == null || this.checkBox.isDisposed()) {
            return;
        }
        GridData gd = (GridData)this.checkBox.getLayoutData();
        gd.horizontalIndent = width;
        this.checkBox.getParent().update();
    }

    public void cut() {
    }

    public void copy() {
    }

    public void paste() {
    }

    public void delete() {
    }
}

