/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.IAttributeContentProposalProvider;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeContentProposalProviderFactory {
    private static List<IAttributeContentProposalProvider> EMPTY = new ArrayList<IAttributeContentProposalProvider>();
    static String POINT_ID = "org.jboss.tools.common.model.ui.attributeContentProposalProviders";

    public static KeyStroke getCtrlSpaceKeyStroke() {
        KeyStroke ks = null;
        try {
            ks = KeyStroke.getInstance((String)"Ctrl+Space");
        }
        catch (ParseException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        return ks;
    }

    public static void registerContentAssist(DefaultValueAdapter valueAdapter, Control control) {
        AttributeContentProposalProviderFactory.registerContentAssist(valueAdapter, control, null);
    }

    public static void registerContentAssist(DefaultValueAdapter valueAdapter, Control control, IContentProposalListener2 listener) {
        XAttribute attr;
        XModelObject object = valueAdapter.getModelObject();
        XEntityData data = null;
        if (valueAdapter.getAttributeData() != null) {
            data = valueAdapter.getAttributeData().getEntityData();
        }
        if ((attr = valueAdapter.getAttribute()) == null && valueAdapter.getAttributeData() != null) {
            attr = valueAdapter.getAttributeData().getAttribute();
        }
        AttributeContentProposalProviderFactory.registerContentAssist(object, data, attr, control, listener);
    }

    public static void registerContentAssist(XModelObject object, XEntityData data, XAttribute attr, Control control) {
        AttributeContentProposalProviderFactory.registerContentAssist(object, data, attr, control, null);
    }

    public static void registerContentAssist(XModelObject object, XEntityData data, XAttribute attr, Control control, IContentProposalListener2 listener) {
        TextContentAdapter controlAdapter;
        Object object2 = control instanceof Text ? new TextContentAdapter() : (controlAdapter = control instanceof Combo ? new ComboContentAdapter() : null);
        if (controlAdapter == null) {
            return;
        }
        AttributeContentProposalProviderFactory factory = new AttributeContentProposalProviderFactory();
        final List<IAttributeContentProposalProvider> ps = factory.getContentProposalProviders(object, attr);
        boolean added = false;
        for (IAttributeContentProposalProvider p : ps) {
            p.init(object, data, attr);
            IContentProposalProvider cpp = p.getContentProposalProvider();
            if (cpp == null) continue;
            ContentProposalAdapter adapter = new ContentProposalAdapter(control, (IControlContentAdapter)controlAdapter, cpp, AttributeContentProposalProviderFactory.getCtrlSpaceKeyStroke(), null);
            adapter.setPropagateKeys(true);
            adapter.setProposalAcceptanceStyle(p.getProposalAcceptanceStyle());
            if (listener != null) {
                adapter.addContentProposalListener(listener);
            }
            added = true;
        }
        if (!ps.isEmpty()) {
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    for (IAttributeContentProposalProvider p : ps) {
                        p.dispose();
                    }
                }
            });
        }
        if (added) {
            int bits = 16512;
            ControlDecoration controlDecoration = new ControlDecoration(control, bits){

                public Image getImage() {
                    for (IAttributeContentProposalProvider p : ps) {
                        Image image;
                        LabelProvider lp = p.getCustomLabelProbider();
                        if (lp == null || (image = lp.getImage((Object)this.getControl())) == null) continue;
                        return image;
                    }
                    return super.getImage();
                }
            };
            controlDecoration.setMarginWidth(0);
            controlDecoration.setDescriptionText("code assist");
            controlDecoration.setShowHover(true);
            controlDecoration.setShowOnlyOnFocus(true);
            FieldDecoration contentProposalImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
            controlDecoration.setImage(contentProposalImage.getImage());
        }
    }

    public List<IAttributeContentProposalProvider> getContentProposalProviders(XModelObject object, XAttribute attribute) {
        List<IAttributeContentProposalProvider> result = EMPTY;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(POINT_ID);
        IExtension[] es = point.getExtensions();
        int i = 0;
        while (i < es.length) {
            IConfigurationElement[] cs = es[i].getConfigurationElements();
            int j = 0;
            while (j < cs.length) {
                IAttributeContentProposalProvider provider = null;
                try {
                    Object o = cs[j].createExecutableExtension("class");
                    provider = (IAttributeContentProposalProvider)o;
                }
                catch (CoreException e) {
                    ModelUIPlugin.getPluginLog().logError((Throwable)e);
                }
                if (provider.isRelevant(object, attribute)) {
                    if (result == EMPTY) {
                        result = new ArrayList<IAttributeContentProposalProvider>();
                    }
                    result.add(provider);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static IContentProposal makeContentProposal(final String proposal, final String label, final String description) {
        return new IContentProposal(){

            public String getContent() {
                return proposal;
            }

            public String getDescription() {
                return description;
            }

            public String getLabel() {
                return label;
            }

            public int getCursorPosition() {
                return proposal.length();
            }
        };
    }
}

