/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.editor.form;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.forms.ExpandableForm;
import org.jboss.tools.common.model.ui.widgets.DefaultSettings;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.WhiteSettings;

public class SamplePropertyForm
extends ExpandableForm
implements PropertyChangeListener {
    private XAttributeSupport support;
    private XModelObject xmo;
    private IWidgetSettings settings = new WhiteSettings();
    private boolean isGreedy = false;

    public SamplePropertyForm() {
        this.support = new SampleXAttributeSupport(this.settings);
        this.support.addPropertyChangeListener(this);
    }

    public void dispose() {
        super.dispose();
        if (this.support != null) {
            this.support.dispose();
        }
        this.support = null;
    }

    protected Control createClientArea(Composite parent, IWidgetSettings factory) {
        String elementType;
        Composite composite = new Composite(parent, 0);
        this.settings.setupControl((Control)composite);
        GridLayout layout = new GridLayout(2, Boolean.FALSE.booleanValue());
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        composite.setLayout((Layout)layout);
        if (this.isGreedy) {
            composite.setLayoutData((Object)new GridData(1808));
        }
        if ((elementType = this.xmo.getAttributeValue("element type")) != null) {
            Label label = new Label(composite, 0);
            GridData gd = new GridData(768);
            gd.horizontalSpan = layout.numColumns;
            label.setLayoutData((Object)gd);
            label.setText(elementType);
            label.setBackground(composite.getBackground());
            Font f = label.getFont();
            FontData[] d = f.getFontData();
            int i = 0;
            while (i < d.length) {
                d[i].setStyle(1);
                ++i;
            }
            label.setFont(new Font(null, d));
        }
        this.updateEnablement();
        this.support.fillComposite(composite);
        return composite;
    }

    public void initialize(Object model) {
        this.xmo = (XModelObject)model;
        this.model = this.xmo.getModel();
        XEntityData data = this.createEntityData();
        if (data != null) {
            this.support.init(this.xmo, data, true);
        } else {
            this.support.init(this.xmo);
        }
        this.isGreedy = false;
        XAttribute[] as = this.xmo.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length && !this.isGreedy) {
            if ("always".equals(as[i].getProperty("greedy"))) {
                this.isGreedy = true;
            }
            ++i;
        }
        this.updateEnablement();
        this.support.setAutoStore(Boolean.TRUE);
        this.setHeadingText("Properties Editor");
    }

    XEntityData createEntityData() {
        if (this.xmo == null) {
            return null;
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(new String[]{this.xmo.getModelEntity().getName()});
        XAttribute[] as = this.xmo.getModelEntity().getAttributes();
        int i = 0;
        while (i < as.length) {
            if (!"element type".equals(as[i].getName()) && as[i].isVisible()) {
                list.add(new String[]{as[i].getName(), "no"});
            }
            ++i;
        }
        String[][] ss = (String[][])list.toArray((T[])new String[0][]);
        return XEntityDataImpl.create((String[][])ss);
    }

    public void update() {
        if (this.support != null) {
            this.support.load();
        }
    }

    public IWidgetSettings getSettings() {
        if (this.settings == null) {
            this.settings = new DefaultSettings();
        }
        return this.settings;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateEnablement();
    }

    public void updateEnablement() {
        if (this.support != null) {
            this.support.updateEnablementByModelObject();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.updateEnablement();
    }

    public boolean doGlobalAction(String actionId) {
        return this.support.doGlobalAction(actionId);
    }

    class SampleXAttributeSupport
    extends XAttributeSupport {
        SampleXAttributeSupport(IWidgetSettings settings) {
            super(settings);
        }

        protected boolean keepGreedy(String name, int index, int greedyCount) {
            return this.alwaysGreedy.contains(name);
        }
    }
}

