/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.webprj.model.handlers;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.handlers.HUtil;
import org.jboss.tools.common.meta.constraint.XAttributeConstraint;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintAList;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintProperties;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebPrjSupport
extends SpecialWizardSupport {
    protected void reset() {
        this.prepareStep(this.target, this.getStepId());
    }

    public void action(String name) throws XModelException {
        if (NEXT.equals(name)) {
            int step = this.getStepId();
            try {
                int res = this.doStep(this.target, step);
                this.setStepId(this.getStepId() + res);
            }
            finally {
                int next = this.getStepId();
                if (next != step) {
                    this.prepareStep(this.target, next);
                }
            }
        } else if (BACK.equals(name)) {
            int res = this.undoStep(this.target, this.getStepId());
            this.setStepId(this.getStepId() + res);
            this.prepareStep(this.target, this.getStepId());
        } else if (CANCEL.equals(name)) {
            this.p.setProperty("canceled", "true");
            this.setFinished(true);
        } else if (FINISH.equals(name)) {
            int res = this.doStep(this.target, this.getStepId());
            if (res > 0) {
                this.setFinished(true);
                this.p.setProperty("finished", "true");
            }
        } else if ("Stop".equals(name)) {
            this.stopThread(true);
            this.action(NEXT);
        }
    }

    public abstract String getDescription();

    public abstract Step getStep(int var1);

    public String getAttributeMessage(int stepId, String attrname) {
        String msg;
        XAttributeData attr = this.findAttribute(stepId, attrname);
        XAttributeConstraint cons = attr.getAttribute().getConstraint();
        if (cons instanceof XAttributeConstraintProperties) {
            Properties p = ((XAttributeConstraintProperties)cons).getProperties();
            msg = p.getProperty("description");
        } else {
            msg = String.valueOf(Character.toUpperCase(attrname.charAt(0))) + attrname.substring(1);
        }
        return String.valueOf(msg) + (attr.getMandatoryFlag() ? "*" : "");
    }

    protected static void setConstraint(XEntityData data, String attr, List<String> values) {
        XAttributeData ad = HUtil.find((Object)new XEntityData[]{data}, (int)0, (String)attr);
        XAttribute a = ad.getAttribute();
        XAttributeConstraintAList c = (XAttributeConstraintAList)a.getConstraint();
        Object[] vs = values.toArray(new String[values.size()]);
        Arrays.sort(vs);
        c.setValues((String[])vs);
    }

    protected void changeAttributeValue(XModelObject object, String name, String value) throws XModelException {
        object.getModel().changeObjectAttribute(object, name, value);
    }

    protected XEntityData getEntityData(XModelObject object, int step) {
        return this.getEntityData()[step];
    }

    public String getTitle() {
        String title = super.getTitle();
        if (title.endsWith("...")) {
            title = title.substring(0, title.length() - 3);
        }
        return String.valueOf(title) + " - " + this.getStep(this.getStepId()).getTitle();
    }

    public String[] getActionNames(int stepId) {
        return this.getStep(stepId).getActionNames();
    }

    public String getMessage(int stepId) {
        return this.getStep(stepId).getMessage();
    }

    public int prepareStep(XModelObject object, int stepId) {
        return this.getStep(stepId).prepareStep(object);
    }

    public int doStep(XModelObject object, int stepId) throws XModelException {
        return this.getStep(stepId).doStep(object);
    }

    public int undoStep(XModelObject object, int stepId) {
        return this.getStep(stepId).undoStep(object);
    }

    public static interface Step {
        public int prepareStep(XModelObject var1);

        public int doStep(XModelObject var1) throws XModelException;

        public int undoStep(XModelObject var1);

        public String getTitle();

        public String[] getActionNames();

        public String getMessage();
    }
}

