/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.validators.model.helpers;

import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.validators.model.helpers.Registrator;

public class ValidatorRegistrationHelper {
    static ValidatorRegistrationHelper instance;
    protected Registrator[] registrators = new Registrator[]{new Registrator("org.jboss.tools.struts.strutsnature", "org.jboss.tools.struts.plugins.model.handlers.ValidationFileRegistration")};

    public static ValidatorRegistrationHelper getInstance() {
        if (instance == null) {
            instance = new ValidatorRegistrationHelper();
        }
        return instance;
    }

    private ValidatorRegistrationHelper() {
    }

    public boolean isEnabled(XModel model) {
        int i = 0;
        while (i < this.registrators.length) {
            if (this.registrators[i].canRegister(model)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getRegistratorNature(XModel model) {
        int i = 0;
        while (i < this.registrators.length) {
            if (this.registrators[i].canRegister(model)) {
                return this.registrators[i].nature;
            }
            ++i;
        }
        return null;
    }

    public void register(XModel model, XModelObject file) {
        int i = 0;
        while (i < this.registrators.length) {
            if (this.registrators[i].canRegister(model)) {
                this.registrators[i].register(model, file, null, false);
            }
            ++i;
        }
    }

    public boolean isRegistered(XModel model, XModelObject file) {
        int i = 0;
        while (i < this.registrators.length) {
            if (this.registrators[i].canRegister(model) && this.registrators[i].register(model, file, null, true)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void update(XModel model, XModelObject file, String oldPath) {
        int i = 0;
        while (i < this.registrators.length) {
            if (this.registrators[i].canRegister(model)) {
                this.registrators[i].register(model, file, oldPath, false);
            }
            ++i;
        }
    }

    public void unregister(XModel model, String oldPath) {
        int i = 0;
        while (i < this.registrators.length) {
            if (this.registrators[i].canRegister(model)) {
                this.registrators[i].register(model, null, oldPath, false);
            }
            ++i;
        }
    }
}

