/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers;

import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.files.handlers.CreateFileSupport;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.project.Watcher;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.project.WebModuleImpl;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.model.StrutsProcessImpl;
import org.jboss.tools.struts.model.handlers.SetupModuleHandler;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;
import org.jboss.tools.struts.webprj.model.helpers.sync.SortFileSystems;
import org.jboss.tools.struts.webprj.model.helpers.sync.StrutsWebHelper;

public class CreateStrutsConfigSupport
extends CreateFileSupport
implements StrutsConstants {
    private Set<String> modules = new HashSet<String>();
    private Set<String> incompleteModules = new HashSet<String>();
    private String module;

    public void reset() {
        super.reset();
        this.initDefaultName();
    }

    public void initDefaultName() {
        String name;
        this.modules.clear();
        this.incompleteModules.clear();
        this.modules.addAll(WebModulesHelper.getInstance(this.getTarget().getModel()).getModules());
        XModelObject web = this.getTarget().getModel().getByPath("Web");
        if (web == null) {
            return;
        }
        XModelObject[] ws = web.getChildren(WebModulesHelper.ENT_STRUTS_WEB_MODULE);
        int i = 0;
        while (i < ws.length) {
            String p = ws[i].getAttributeValue("model path");
            if (p == null || p.length() == 0 || this.getTarget().getModel().getByPath(p) == null) {
                this.incompleteModules.add(ws[i].getAttributeValue("name"));
            }
            ++i;
        }
        HashSet<String> names = new HashSet<String>();
        XModelObject[] cs = this.getTarget().getChildren();
        int i2 = 0;
        while (i2 < cs.length) {
            String entity = cs[i2].getModelEntity().getName();
            if (entity.startsWith("StrutsConfig") && !entity.equals("StrutsConfig10")) {
                names.add(cs[i2].getAttributeValue("name"));
            }
            ++i2;
        }
        if (this.modules.size() <= this.incompleteModules.size() && names.size() == 0) {
            this.setAttributeValue(0, "module", "");
            this.setAttributeValue(0, "name", "struts-config");
            return;
        }
        String module = "/mod";
        int i3 = 1;
        while (this.modules.contains(String.valueOf(module) + i3) && !this.incompleteModules.contains(String.valueOf(module) + i3)) {
            ++i3;
        }
        module = String.valueOf(module) + i3;
        this.setAttributeValue(0, "module", module);
        String namef = name = "struts-config-" + module.substring(1);
        i3 = 0;
        while (names.contains(namef)) {
            namef = String.valueOf(name) + ++i3;
        }
        this.setAttributeValue(0, "name", namef);
    }

    protected void execute() throws XModelException {
        Properties p0 = this.extractStepData(0);
        XUndoManager undo = this.getTarget().getModel().getUndoManager();
        XTransactionUndo u = new XTransactionUndo(NLS.bind((String)StrutsUIMessages.CREATE_STRUTS_CONFIG, (Object)(String.valueOf(this.getTarget().getAttributeValue("element type")) + " " + this.getTarget().getPresentationString())), 1);
        undo.addUndoable((XUndoable)u);
        try {
            try {
                this.doExecute(p0);
            }
            catch (RuntimeException e) {
                undo.rollbackTransactionInProgress();
                throw e;
            }
        }
        finally {
            u.commit();
        }
    }

    private void doExecute(Properties p0) throws XModelException {
        Properties p = this.extractStepData(0);
        String path = p.getProperty("name");
        XModelObject file = this.createFile(path = this.revalidatePath(path));
        if (file == null) {
            return;
        }
        StrutsProcessImpl process = (StrutsProcessImpl)file.getChildByPath("process");
        process.firePrepared();
        this.register(file, p0);
        SortFileSystems.sort(this.getTarget().getModel());
        XModelObject q = file;
        this.open(q);
    }

    protected XModelObject modifyCreatedObject(XModelObject o) {
        this.module = this.getAttributeValue(0, "module");
        if (this.module != null && this.module.length() > 0 && !this.module.startsWith("/")) {
            this.module = "/" + this.module;
            this.setAttributeValue(0, "module", this.module);
        }
        return o;
    }

    private String checkRegister(XModelObject object, String register) {
        if (!"yes".equals(register)) {
            return null;
        }
        XModelObject webxml = WebAppHelper.getWebApp((XModel)object.getModel());
        if (webxml == null) {
            return StrutsUIMessages.MODULE_CANNOT_BE_REGISTERED_ISNOT_FOUND;
        }
        if ("yes".equals(webxml.get("isIncorrect"))) {
            return StrutsUIMessages.MODULE_CANNOT_BE_REGISTERED_IS_INCORRECT;
        }
        if (!webxml.isObjectEditable()) {
            return StrutsUIMessages.MODULE_CANNOT_BE_REGISTERED_IS_READONLY;
        }
        return null;
    }

    private void register(XModelObject object, Properties prop) throws XModelException {
        boolean register;
        String uri = this.getURI(object);
        XModelObject m = object.getModel().getByPath("Web/" + this.module.replace('/', '#'));
        if (this.incompleteModules.contains(this.module)) {
            if (m != null && uri.equals(m.getAttributeValue("URI"))) {
                m.getModel().changeObjectAttribute(m, "model path", XModelObjectLoaderUtil.getResourcePath((XModelObject)object));
            }
        } else if (m == null) {
            SetupModuleHandler.setupModule(object.getChildByPath("process"), this.module, null);
            m = object.getModel().getByPath("Web/" + this.module.replace('/', '#'));
        }
        if (!(register = "yes".equals(this.getAttributeValue(0, "register in web.xml")))) {
            return;
        }
        String uri2 = StrutsWebHelper.registerConfig(object.getModel(), this.module, uri);
        if (m != null && uri.equals(uri2)) {
            object.getModel().changeObjectAttribute(m, "URI", uri);
        } else if (m != null) {
            WebModuleImpl mi = (WebModuleImpl)m;
            mi.setURI(uri2);
            XModelObject c = mi.getChildByPath(uri.replace('/', '#'));
            if (c != null) {
                c.setAttributeValue("model path", XModelObjectLoaderUtil.getResourcePath((XModelObject)object));
            }
        }
        Watcher.getInstance((XModel)object.getModel()).forceUpdate();
        XModelObject webxml = WebAppHelper.getWebApp((XModel)object.getModel());
        if (webxml != null && webxml.isModified()) {
            XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)webxml, null);
        }
    }

    private String getURI(XModelObject file) {
        String result = "/" + FileAnyImpl.toFileName((XProperty)file);
        XModelObject o = file.getParent();
        while (o != null && o.getFileType() != 3) {
            result = "/" + o.getAttributeValue("name") + result;
            o = o.getParent();
        }
        if (o == null || !"WEB-ROOT".equals(o.getAttributeValue("name"))) {
            result = "/WEB-INF" + result;
        }
        return result;
    }

    protected DefaultWizardDataValidator createValidator() {
        return new CreateStrutsConfigValidator();
    }

    class CreateStrutsConfigValidator
    extends CreateFileSupport.Validator {
        CreateStrutsConfigValidator() {
            super((CreateFileSupport)CreateStrutsConfigSupport.this);
        }

        public void validate(Properties data) {
            super.validate(data);
            if (this.message != null) {
                return;
            }
            this.message = CreateStrutsConfigSupport.this.checkRegister(CreateStrutsConfigSupport.this.getTarget(), data.getProperty("register in web.xml"));
        }
    }
}

