/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.workbench.common.dmn.client.widgets.grid.controls;

import java.util.Optional;

import org.jboss.errai.common.client.api.IsElement;

public interface HasCellEditorControls {

    interface Editor<T> extends IsElement {

        void show(final Optional<String> editorTitle);

        void hide();

        void bind(final T bound,
                  final int uiRowIndex,
                  final int uiColumnIndex);
    }

    default Optional<Editor> getEditor() {
        return Optional.empty();
    }
}
