package com.redhat.installer.installation.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public abstract class BinaryInPathValidator implements DataValidator {
    protected abstract String getWarningId();
    protected abstract String getBinaryName();
    protected abstract Status getFailureStatus();

    @Override
    public Status validateData(AutomatedInstallData adata) {
        final String executableName = getBinaryName();
        boolean existsInPath = Stream.of(System.getenv("PATH").split(Pattern.quote(File.pathSeparator)))
                .map(Paths::get)
                .anyMatch(path -> Files.exists(path.resolve(executableName)));
        return existsInPath ? Status.OK : getFailureStatus();
    }

    @Override
    public String getErrorMessageId() {
        return null;
    }

    @Override
    public String getWarningMessageId() {
        return getWarningId();
    }

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return AutomatedInstallData.getInstance().langpack.getString(getWarningId());
    }
}
