package com.redhat.installer.installation.processpanel;

import java.io.File;
import java.io.IOException;

import org.apache.commons.io.FileUtils;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import com.izforge.izpack.util.VariableSubstitutor;

/**
 * Intended usage of this class is to solve
 * https://bugzilla.redhat.com/show_bug.cgi?id=1010968 in a general way. It
 * simply deletes the file at the given path. Used for when the server or some
 * post-install job modifies the install directory, and we must revert or delete
 * some files as a result of this.
 *
 * If the argument deleteTmp is detected, delete all files held by the idata.tmpFiles variable.
 *f
 * @author thauser
 */

public class FileDeleter {
    public static final String MSG_ENABLED = "enable-messages";

    private static void deleteFile(File toDelete, boolean displayMessages, AbstractUIProcessHandler handler, AutomatedInstallData idata){
        try {
            FileUtils.forceDelete(toDelete);
            if (displayMessages)
                ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("FileDeleter.success") + " " + toDelete.getAbsolutePath(), false);
        } catch (IOException e) {
            if (displayMessages)
                ProcessPanelHelper.printToPanel(handler, idata.langpack.getString("FileDeleter.failure") + " " + toDelete.getAbsolutePath(), true);
            ProcessPanelHelper.printToLog(e.toString());
        }
    }

    private static void deleteTmpFiles(boolean displayMessages, AbstractUIProcessHandler handler, AutomatedInstallData idata){
        for(String file : idata.tmpFiles){
            File toDelete = new File(file);
            if(toDelete.exists())deleteFile(toDelete, displayMessages, handler, idata);
        }
    }

    public static void run(AbstractUIProcessHandler handler, String[] args) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        ArgumentParser parser = new ArgumentParser();
        parser.parse(args);

        boolean displayMessages = parser.hasProperty(MSG_ENABLED);

        for (String arg : args) {
            if (arg!= null) {
                if(arg.equals("deleteTmp")) deleteTmpFiles(displayMessages, handler, idata);
                else {
                    File toDelete = new File(vs.substitute(arg));
                    if (toDelete.exists()) deleteFile(toDelete, displayMessages, handler, idata);
                }
            }
        }
    }
}
