/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceGradientBackgroundDelegate;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;

public class SubstanceMenuBackgroundDelegate {
    private static SubstanceGradientBackgroundDelegate activeBackgroundDelegate = new SubstanceGradientBackgroundDelegate();
    private SubstanceFillBackgroundDelegate fillBackgroundDelegate;

    public SubstanceMenuBackgroundDelegate(float fillAlpha) {
        this.fillBackgroundDelegate = new SubstanceFillBackgroundDelegate(fillAlpha);
    }

    private void paintBackground(Graphics g, JMenuItem menuItem, int width, int height, SubstanceTheme theme, float borderAlpha) {
        activeBackgroundDelegate.update(g, menuItem, width, height, theme, borderAlpha);
    }

    public void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor, float borderAlpha, int textOffset) {
        boolean hasHighlight;
        float endAlpha;
        if (!menuItem.isShowing()) {
            return;
        }
        ButtonModel model = menuItem.getModel();
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        MenuElement[] selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath();
        boolean isRollover = selectedMenuPath.length == 0;
        for (MenuElement elem : selectedMenuPath) {
            if (elem != menuItem) continue;
            isRollover = true;
            break;
        }
        isRollover = isRollover && model.isRollover();
        Graphics2D graphics = (Graphics2D)g.create();
        if (TransitionLayout.isOpaque(menuItem)) {
            graphics.setColor(menuItem.getBackground());
            graphics.fillRect(0, 0, menuWidth, menuHeight);
            this.fillBackgroundDelegate.setAlphaComposite(0.4f);
            for (Container comp = menuItem.getParent(); comp != null && !(comp instanceof JMenuItem); comp = comp.getParent()) {
                if (!(comp instanceof JMenuBar)) continue;
                this.fillBackgroundDelegate.setAlphaComposite(1.0f);
                break;
            }
            if (TransitionLayout.isOpaque(menuItem)) {
                this.fillBackgroundDelegate.update(graphics, menuItem, menuItem.getParent() instanceof JMenuBar);
            }
            if (menuItem.getParent() instanceof JPopupMenu) {
                GradientPaint gp;
                Color rightColor;
                Color leftColor;
                ColorScheme scheme;
                if (menuItem.getComponentOrientation().isLeftToRight()) {
                    SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                    if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                        scheme = SubstanceCoreUtilities.getActiveScheme(menuItem);
                        leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getUltraLightColor() : scheme.getLightColor();
                        rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getUltraLightColor() : scheme.getLightColor();
                        gp = new GradientPaint(0.0f, 0.0f, leftColor, textOffset, 0.0f, rightColor);
                        graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, 0.7f, g));
                        graphics.setPaint(gp);
                        graphics.fillRect(0, 0, textOffset - 2, menuHeight);
                    }
                } else {
                    SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                    if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                        scheme = SubstanceCoreUtilities.getActiveScheme(menuItem);
                        leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getLightColor() : scheme.getUltraLightColor();
                        rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getLightColor() : scheme.getUltraLightColor();
                        gp = new GradientPaint(menuWidth - textOffset, 0.0f, leftColor, menuWidth, 0.0f, rightColor);
                        graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, 0.7f, g));
                        graphics.setPaint(gp);
                        graphics.fillRect(menuWidth - textOffset - 2, 0, menuWidth, menuHeight);
                    }
                }
            }
        }
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(menuItem);
        ComponentState currState = ComponentState.getState(model, menuItem, !(menuItem instanceof JMenu));
        float alphaForPrevBackground = 0.0f;
        float startAlpha = SubstanceCoreUtilities.getHighlightAlpha(menuItem, prevState, true);
        float alphaForCurrBackground = endAlpha = SubstanceCoreUtilities.getHighlightAlpha(menuItem, currState, true);
        SubstanceTheme prevTheme = SubstanceCoreUtilities.getHighlightTheme((Component)menuItem, prevState, true, false);
        SubstanceTheme currTheme = SubstanceCoreUtilities.getHighlightTheme((Component)menuItem, currState, true, false);
        FadeState state = SubstanceFadeUtilities.getFadeState((Component)menuItem, FadeKind.SELECTION, FadeKind.ARM, FadeKind.ROLLOVER);
        if (state != null) {
            float fadeCoef = state.getFadePosition();
            float totalAlpha = 0.0f;
            totalAlpha = state.isFadingIn() ? startAlpha + (endAlpha - startAlpha) * fadeCoef / 10.0f : startAlpha + (endAlpha - startAlpha) * (10.0f - fadeCoef) / 10.0f;
            if (state.isFadingIn()) {
                fadeCoef = 10.0f - fadeCoef;
            }
            alphaForPrevBackground = totalAlpha * fadeCoef / 10.0f;
            alphaForCurrBackground = totalAlpha * (10.0f - fadeCoef) / 10.0f;
        }
        boolean bl = hasHighlight = state != null || model.isArmed() || isRollover || menuItem instanceof JMenu && model.isSelected();
        if (hasHighlight && alphaForPrevBackground > 0.0f) {
            graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, alphaForPrevBackground, g));
            this.paintBackground(graphics, menuItem, menuWidth, menuHeight, prevTheme, borderAlpha);
            graphics.setComposite(TransitionLayout.getAlphaComposite((Component)menuItem, g));
        }
        if (hasHighlight && alphaForCurrBackground > 0.0f) {
            graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, alphaForCurrBackground, g));
            this.paintBackground(graphics, menuItem, menuWidth, menuHeight, currTheme, borderAlpha);
            graphics.setComposite(TransitionLayout.getAlphaComposite((Component)menuItem, g));
        }
        graphics.dispose();
    }
}

