package com.izforge.izpack.util;

import java.io.File;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;


/**
 * This class represents a simple validator to test if a file exists.
 */
public class FileValidator implements Validator {
    /**
     * FileValidator
     * Validates the given file
     *
     * @param client the client object using the services of this validator.
     * @return <code>true</code> if the validation passes, otherwise <code>false</code>.
     */
    public Status validate(ProcessingClient client) {

        Status failureStatus = WARNING_DEFAULT;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get(WARNING_PARAM)))
            failureStatus = Status.WARNING;


        String value = client.getFieldContents(0);

        if ((value == null) || (value.length() == 0)) {
            return failureStatus;
        }
        boolean validationResult = pathMatches(value);

        if (!validationResult)
            return failureStatus;

        return Status.OK;
    }


    private boolean pathMatches(String path) {
        if (path != null) {
            File file = new File(path);
            if (file.isFile()) {
                return true;
            }
        }
        return false;
    }
}
