package com.izforge.izpack.gui;

import javax.swing.*;
import java.awt.*;

/**
 * Created by thauser on 5/7/15.
 */
public class PanelFactory {

    public static JPanel createContentPanel(boolean isOpaque){
        JPanel contentPanel = new JPanel(new GridBagLayout());
        contentPanel.setOpaque(isOpaque);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = GridBagConstraints.LAST_LINE_START;
        gbc.weightx = 1;
        gbc.weighty = 1;
        gbc.gridx = 100;
        gbc.gridy = 100;
        gbc.gridwidth = 100;
        gbc.gridheight = 100;
        gbc.fill = GridBagConstraints.BOTH;
        contentPanel.add(Box.createGlue(), gbc);
        contentPanel.setBorder(BorderFactory.createEmptyBorder());
        return contentPanel;
    }

    public static JPanel createMainPanel(boolean isOpaque){
        JPanel panel = new JPanel();
        panel.setOpaque(isOpaque);
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        return panel;
    }

    public static JPanel createRadioContentPanel(boolean isOpaque){
        JPanel contentPanel = new JPanel();
        contentPanel.setOpaque(isOpaque);
        contentPanel.setBorder(BorderFactory.createEmptyBorder());
        return contentPanel;
    }

    public static JPanel createRadioButtonPanel(boolean isOpaque, final ButtonGroup group){
        JPanel buttonPanel = createRadioContentPanel(isOpaque);
        buttonPanel.setFocusTraversalPolicyProvider(true);
        buttonPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy() {

            @Override
            public Component getDefaultComponent(Container focusCycleRoot) {
                ButtonModel selection = group.getSelection();
                for (Component c: focusCycleRoot.getComponents()) {
                    if (c instanceof Box) {
                        for (Component bc :((Box) c).getComponents()) {
                            if (bc instanceof JRadioButton) {
                                JRadioButton radioBtn = (JRadioButton) bc;
                                if (!radioBtn.isEnabled()) {
                                    return null;
                                }
                                ButtonModel loopModel = radioBtn.getModel();
                                if (loopModel == selection) {
                                    return radioBtn;
                                }
                            }
                        }
                    }
                }
                return super.getDefaultComponent(focusCycleRoot);
            }
            @Override
            public Component getLastComponent(Container focusCycleRoot){
               return getDefaultComponent(focusCycleRoot);
            }
        });
        return buttonPanel;
    }
}
