package com.redhat.installer.installation.processpanel;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.util.AbstractUIProcessHandler;
import org.apache.commons.lang.SystemUtils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.stream.Collectors;

public class TomcatModifySetenv {

    private static AbstractUIProcessHandler mHandler;
    private static AutomatedInstallData idata;
    private static final String linuxFileTextTemplate = "export CATALINA_OPTS=\"$CATALINA_OPTS %s\"";
    private static final String windowsFileTextTemplate = "set \"CATALINA_OPTS=%%CATALINA_OPTS%% %s";


    public static boolean run(AbstractUIProcessHandler handler, String[] args) {
        mHandler = handler;
        idata = AutomatedInstallData.getInstance();
        String propertyText = createPropertyText(args);
        return modifyTomcatSetenv(propertyText);
    }

    private static String createPropertyText(String[] setProperties) {
        return Arrays.stream(setProperties).map(property -> property.replace(";", "\\;")).collect(Collectors.joining(" "));
    }

    private static boolean modifyTomcatSetenv(String propertyText) {
        try {
            Path setenvPath;
            String templateText;
            if (SystemUtils.IS_OS_WINDOWS) {
                setenvPath = Paths.get(idata.getInstallPath() + "/bin/setenv.bat");
                templateText = windowsFileTextTemplate;
            } else {
                setenvPath = Paths.get(idata.getInstallPath() + "/bin/setenv.sh");
                templateText = linuxFileTextTemplate;
            }
            String textToWrite = String.format("\n"+templateText, propertyText);
            Files.write(setenvPath, textToWrite.getBytes(), Files.exists(setenvPath) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
        } catch (IOException e) {
            ProcessPanelHelper.printToPanel(mHandler, idata.langpack.getString("tomcat.setenv.writefailed"), false);
            ProcessPanelHelper.printExceptionToLog(e.getStackTrace());
            return false;
        }
        return true;
    }
}
