package com.redhat.installer.asconfiguration.jdbc.validator;

/**
 * Created by mvaghela on 19/05/16.
 */
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.panels.MultiMessageValidator;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.redhat.installer.asconfiguration.utils.JarUtils;

import java.util.*;

/**
 * Created by mvaghela on 02/05/16.
 */
public class JDBCJarExistsValidator implements Validator, MultiMessageValidator {

    private String formatedMessage;

    public Status validate(ProcessingClient client)
    {
        AutomatedInstallData adata = AutomatedInstallData.getInstance();

        //grabs the stack of jars that need to be validated
        Stack<List<String>> stack = (Stack<List<String>>) adata.getAttribute("dynamic.component.values");

        if(stack != null) {

            Status failureStatus = Status.ERROR;
            if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get(WARNING_PARAM)))
                failureStatus = Status.WARNING;

            for (int i = 0; i < stack.size(); i++) {
                String jarPath = stack.get(i).get(0);

                switch (JarUtils.verifyJarPath(jarPath)) {
                    case 1: // given path doesn't exist (or is directory)
                        setFormattedMessage(String.format(adata.langpack.getString("JBossJDBCDriverSetupPanel.path.error"),
                                jarPath));
                        return failureStatus;
                    case 2: // given path isn't a zip
                        setFormattedMessage(String.format(adata.langpack.getString("JBossJDBCDriverSetupPanel.path" +
                                ".notzip"), jarPath));
                        return failureStatus;
                    case 3: // given path is a zip, but an empty one
                        setFormattedMessage(String.format(adata.langpack.getString("JBossJDBCDriverSetupPanel.path" +
                                ".emptyzip"), jarPath));
                        return failureStatus;
                    case 4: // given remote location isn't reachable
                        setFormattedMessage(String.format(adata.langpack.getString("JBossJDBCDriverSetupPanel.path.remote" +
                                ".error"), jarPath));
                        return failureStatus;
                    case 5:
                        setFormattedMessage(String.format(adata.langpack.getString("JBossJDBCDriverSetupPanel.path" +
                                ".exception.error"), jarPath));
                        return failureStatus;
                }
            }
        }
        return Status.OK;
    }

    public void setFormattedMessage(String message) {
        formatedMessage = message;
    }

    public String getMessage(){
        return formatedMessage;
    }
}
