/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.DocumentableNode;
import com.github.javaparser.ast.NamedNode;
import com.github.javaparser.ast.TypeParameter;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ModifierSet;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.WithDeclaration;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import java.util.ArrayList;
import java.util.List;

public final class MethodDeclaration
extends BodyDeclaration
implements DocumentableNode,
WithDeclaration,
NamedNode {
    private int modifiers;
    private List<TypeParameter> typeParameters;
    private Type type;
    private NameExpr name;
    private List<Parameter> parameters;
    private int arrayCount;
    private List<NameExpr> throws_;
    private BlockStmt body;
    private boolean isDefault = false;
    private JavadocComment javadocComment;

    public MethodDeclaration() {
    }

    public MethodDeclaration(int modifiers, Type type, String name) {
        this.setModifiers(modifiers);
        this.setType(type);
        this.setName(name);
    }

    public MethodDeclaration(int modifiers, Type type, String name, List<Parameter> parameters) {
        this.setModifiers(modifiers);
        this.setType(type);
        this.setName(name);
        this.setParameters(parameters);
    }

    public MethodDeclaration(int modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, Type type, String name, List<Parameter> parameters, int arrayCount, List<NameExpr> throws_, BlockStmt block) {
        super(annotations);
        this.setModifiers(modifiers);
        this.setTypeParameters(typeParameters);
        this.setType(type);
        this.setName(name);
        this.setParameters(parameters);
        this.setArrayCount(arrayCount);
        this.setThrows(throws_);
        this.setBody(block);
    }

    public MethodDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, int modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, Type type, String name, List<Parameter> parameters, int arrayCount, List<NameExpr> throws_, BlockStmt block) {
        super(beginLine, beginColumn, endLine, endColumn, annotations);
        this.setModifiers(modifiers);
        this.setTypeParameters(typeParameters);
        this.setType(type);
        this.setName(name);
        this.setParameters(parameters);
        this.setArrayCount(arrayCount);
        this.setThrows(throws_);
        this.setBody(block);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public BlockStmt getBody() {
        return this.body;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getName() {
        return this.name.getName();
    }

    public NameExpr getNameExpr() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        return this.parameters;
    }

    public List<NameExpr> getThrows() {
        if (this.throws_ == null) {
            this.throws_ = new ArrayList<NameExpr>();
        }
        return this.throws_;
    }

    public Type getType() {
        return this.type;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public void setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
    }

    public void setBody(BlockStmt body) {
        this.body = body;
        this.setAsParentNodeOf(this.body);
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setName(String name) {
        this.name = new NameExpr(name);
    }

    public void setNameExpr(NameExpr name) {
        this.name = name;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        this.setAsParentNodeOf(this.parameters);
    }

    public void setThrows(List<NameExpr> throws_) {
        this.throws_ = throws_;
        this.setAsParentNodeOf(this.throws_);
    }

    public void setType(Type type) {
        this.type = type;
        this.setAsParentNodeOf(this.type);
    }

    public void setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
        this.setAsParentNodeOf(typeParameters);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public String getDeclarationAsString() {
        return this.getDeclarationAsString(true, true, true);
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows) {
        return this.getDeclarationAsString(includingModifiers, includingThrows, true);
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows, boolean includingParameterName) {
        StringBuffer sb = new StringBuffer();
        if (includingModifiers) {
            AccessSpecifier accessSpecifier = ModifierSet.getAccessSpecifier(this.getModifiers());
            sb.append(accessSpecifier.getCodeRepresenation());
            sb.append(accessSpecifier == AccessSpecifier.DEFAULT ? "" : " ");
            if (ModifierSet.isStatic(this.getModifiers())) {
                sb.append("static ");
            }
            if (ModifierSet.isAbstract(this.getModifiers())) {
                sb.append("abstract ");
            }
            if (ModifierSet.isFinal(this.getModifiers())) {
                sb.append("final ");
            }
            if (ModifierSet.isNative(this.getModifiers())) {
                sb.append("native ");
            }
            if (ModifierSet.isSynchronized(this.getModifiers())) {
                sb.append("synchronized ");
            }
        }
        sb.append(this.getType().toStringWithoutComments());
        sb.append(" ");
        sb.append(this.getName());
        sb.append("(");
        boolean firstParam = true;
        for (Parameter param : this.getParameters()) {
            if (firstParam) {
                firstParam = false;
            } else {
                sb.append(", ");
            }
            if (includingParameterName) {
                sb.append(param.toStringWithoutComments());
                continue;
            }
            sb.append(param.getType().toStringWithoutComments());
            if (!param.isVarArgs()) continue;
            sb.append("...");
        }
        sb.append(")");
        if (includingThrows) {
            boolean firstThrow = true;
            for (NameExpr thr : this.getThrows()) {
                if (firstThrow) {
                    firstThrow = false;
                    sb.append(" throws ");
                } else {
                    sb.append(", ");
                }
                sb.append(thr.toStringWithoutComments());
            }
        }
        return sb.toString();
    }

    @Override
    public void setJavaDoc(JavadocComment javadocComment) {
        this.javadocComment = javadocComment;
    }

    @Override
    public JavadocComment getJavaDoc() {
        return this.javadocComment;
    }
}

