/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import javax.faces.model.NoRowAvailableException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScalarDataModel<E>
extends DataModel<E> {
    private int index;
    private E scalar;

    public ScalarDataModel() {
        this(null);
    }

    public ScalarDataModel(E scalar) {
        this.setWrappedData(scalar);
    }

    public boolean isRowAvailable() {
        if (this.scalar == null) {
            return false;
        }
        return this.index == 0;
    }

    public int getRowCount() {
        if (this.scalar == null) {
            return -1;
        }
        return 1;
    }

    public E getRowData() {
        if (this.scalar == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new NoRowAvailableException();
        }
        return (E)this.scalar;
    }

    public int getRowIndex() {
        return this.index;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int old = this.index;
        this.index = rowIndex;
        if (this.scalar == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, this.index, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    public Object getWrappedData() {
        return this.scalar;
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.scalar = null;
            this.setRowIndex(-1);
        } else {
            this.scalar = data;
            this.index = -1;
            this.setRowIndex(0);
        }
    }
}

