package com.redhat.installer.ports.utils;

import com.izforge.izpack.installer.AutomatedInstallData;

/**
 * Created by eunderhi on 26/01/16.
 * Utility class to get the current port offset this is needed because I have noticed the roundabout
 * way to get the port offset repeated in several places. This centralizes it. The method is as follows:
 * 1. Get the port offset type, if it is non-null then it is one of three values:
 *  -1
 *  -100
 *  -specify
 * 2. If it isn't specify then return 1 or 100
 * 3. If it IS specify then the value is stored in configurePortOffset, so get it from there.
 */
public class PortOffset {

    public static final String OFFSET_TYPE_KEY = "portOffsetType";
    public static final String PORT_KEY = "configurePortOffset";
    public static final String PORT_DECISION_KEY = "portDecision";


    public static int get() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();

        String offset = idata.getVariable(OFFSET_TYPE_KEY);
        if (offset == null || !userWantsOffset()) {
            return 0;
        }
        return Integer.parseInt(
                offset.equals("specify") ? idata.getVariable(PORT_KEY) : offset
        );
    }

    public static String apply(String port) {
        String[] splitPort = port.split(":");
        int portValue = Integer.parseInt(splitPort[1].replace("}", ""));
        return splitPort[0] + ":" + (portValue + get()) + "}";
    }

    private static boolean userWantsOffset() {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        String decision = idata.getVariable(PORT_DECISION_KEY);
        return decision != null && decision.equals("assist");
    }

}
