package com.redhat.installer.layering.validator.container.tomcat;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.redhat.installer.layering.validator.container.HigherVersionValidator;
import com.redhat.installer.layering.validator.container.VersionState;
import com.redhat.installer.layering.validator.container.VersionValidator;
import org.osgi.framework.Version;

public class TomcatValidator implements VersionValidator {
    private final AutomatedInstallData installData;

    public TomcatValidator(AutomatedInstallData installData) {
        this.installData = installData;
    }

    @Override
    public String minSupportedVersion() {
        return installData.getVariable("jws.minimum.version");
    }

    @Override
    public String maxSupportedVersion() {
        return installData.getVariable("jws.maximum.version");
    }

    @Override
    public VersionState validate(Version version) {
        VersionValidator validator = new HigherVersionValidator(minSupportedVersion());
        return validator.validate(version);
    }
}
