package com.redhat.installer.layering.validator.container.tomcat;

import com.redhat.installer.layering.validator.container.BasicContainerInformationLoader;
import com.redhat.installer.layering.validator.container.ContainerInformation;
import com.redhat.installer.layering.validator.container.ContainerInformationLoader;
import com.redhat.installer.layering.validator.container.ContainerType;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;

public class TomcatInformationLoader implements ContainerInformationLoader {
    private static final Path webappsFolder = Paths.get("webapps");

    private final Path installPath;
    private final List<Path> requiredFiles;
    private final List<Path> productFiles;

    public TomcatInformationLoader(Path installPath) {
        this.installPath = installPath;
        this.requiredFiles = createRequiredFiles();
        this.productFiles = createProductFiles();
    }

    private List<Path> createRequiredFiles() {
        // should ensure that version.sh OR version.bat exists
        Path configurationFolder = Paths.get("conf");
        return Arrays.asList(Paths.get("lib/"),
                Paths.get("bin/"),
                configurationFolder.resolve("context.xml"),
                configurationFolder.resolve("server.xml"),
                configurationFolder.resolve("tomcat-users.xml"));
    }

    private List<Path> createProductFiles() {
        return Arrays.asList(webappsFolder.resolve("kie-server"), webappsFolder.resolve("controller"));
    }

    @Override
    public ContainerInformation load() {
        TomcatVersionLoader versionLoader = new TomcatVersionLoader(installPath);
        ContainerInformationLoader containerInformationLoader =
                new BasicContainerInformationLoader(ContainerType.Tomcat, versionLoader, installPath, requiredFiles, productFiles);
        return containerInformationLoader.load();
    }
}
