package com.redhat.installer.layering.validator.container.eap;

import com.redhat.installer.layering.validator.container.BasicContainerInformationLoader;
import com.redhat.installer.layering.validator.container.ContainerInformation;
import com.redhat.installer.layering.validator.container.ContainerInformationLoader;
import com.redhat.installer.layering.validator.container.ContainerType;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;

public class EapInformationLoader implements ContainerInformationLoader {
    private final Path eapDeployments = Paths.get("standalone", "deployments");

    private final Path installPath;
    private final List<Path> requiredEapFiles;
    private final List<Path> eapProductFiles;

    public EapInformationLoader(Path installPath, String productName) {
        this.installPath = installPath;
        this.requiredEapFiles = createRequiredFiles();
        this.eapProductFiles = createProductFiles(productName);
    }

    private List<Path> createRequiredFiles() {
            Path standaloneConfiguration = Paths.get("standalone", "configuration");
            Path domainConfiguration = Paths.get("domain", "configuration");
            Path binFolder = Paths.get("bin");
            return Arrays.asList(standaloneConfiguration.resolve("standalone.xml"),
                    standaloneConfiguration.resolve("standalone-ha.xml"),
                    standaloneConfiguration.resolve("standalone-full.xml"),
                    standaloneConfiguration.resolve("standalone-full-ha.xml"),
                    domainConfiguration.resolve("domain.xml"),
                    domainConfiguration.resolve("host.xml"),
                    binFolder.resolve("add-user.sh"),
                    Paths.get("version.txt"));
    }

    private List<Path> createProductFiles(String productName) {
        if ("rhpam".equals(productName)) {
            return Arrays.asList(eapDeployments.resolve("business-central.war"), eapDeployments.resolve("kie-server.war"));
        } else {
            return Arrays.asList(eapDeployments.resolve("decision-central.war"), eapDeployments.resolve("kie-server.war"));
        }
    }

    @Override
    public ContainerInformation load() {
        EapVersionLoader versionLoader = new EapVersionLoader(installPath);
        ContainerInformationLoader containerInformationLoader = new BasicContainerInformationLoader(ContainerType.EAP,
                versionLoader, installPath, requiredEapFiles, eapProductFiles);
        return containerInformationLoader.load();
    }
}
