package com.redhat.installer.asconfiguration.ldap.validator;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.DataValidator;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.UserInputPanel;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.PasswordEqualityValidator;
import com.redhat.installer.asconfiguration.ldap.utils.LdapUtils;

import javax.naming.directory.DirContext;

/** Verify that we can authenticate with the LDAP server. */
public class LDAPValidator implements DataValidator, Validator {

    String warning;
    String message;

    public DataValidator.Status validateData(AutomatedInstallData adata) {
        if (!connectToLdapConnection()){
            return DataValidator.Status.ERROR;
        }
        return DataValidator.Status.OK;
    }

    private boolean connectToLdapConnection(){
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        setWarningMessageId("Ldap.error");
        message = idata.langpack.getString(warning);
        String dnServer = idata.getVariable("ldap.url");
        String dn = idata.getVariable("ldap.dn");
        String dnPassword = idata.getVariable("ldap.password");
        DirContext ctx = LdapUtils.makeConnection(dnServer, dn, dnPassword);
        if (ctx == null) return false;
        return true;
    }

    //Used through test button of userInputPanel
    public Validator.Status validate(ProcessingClient client)
    {
        if (!validatePasswordField(client)){
            return Validator.Status.ERROR;
        }
        DataValidator.Status status =  validateData(AutomatedInstallData.getInstance());
        Validator.Status validationResult = status == DataValidator.Status.OK ? Validator.Status.OK : Validator.Status.ERROR;
        return validationResult;
    }

    private boolean validatePasswordField(ProcessingClient client) {
        AutomatedInstallData idata = AutomatedInstallData.getInstance();
        PasswordGroup toTest = (PasswordGroup) client;
        if (toTest.getGroupName() != null && !toTest.getGroupName().isEmpty()){
            PasswordEqualityValidator pev = new PasswordEqualityValidator();
            UserInputPanel uip = (UserInputPanel)idata.panels.get(idata.curPanelNumber);
            PasswordGroup processingClient = uip.getPasswordGroups().get(toTest.getGroupName());
            if (pev.validate(processingClient) != Validator.Status.OK){
                setWarningMessageId("username.no.match.password");
                message = AutomatedInstallData.getInstance().langpack.getString(warning);
                return false;
            }
        }
        return true;
    }

    public String getErrorMessageId() {
        return warning;
    }

    public String getWarningMessageId() {
        return warning;
    }

    private void setWarningMessageId(String warning) {
      this.warning = warning;
    }

    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getFormattedMessage() {
        return message;
    }
}