package com.redhat.installer.asconfiguration.jdbc.validator;

import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;

import java.util.HashSet;
import java.util.Set;

/**
 * Created by aabulawi on 30/04/15.
 */
public class NoDuplicatesValidator implements Validator {
    @Override
    public Status validate(ProcessingClient client) {
        Status failureStatus = Status.ERROR;
        if (client.hasParams() && Boolean.parseBoolean(client.getValidatorParams().get(WARNING_PARAM)))
            failureStatus = Status.WARNING;
        Set<String> inputs = new HashSet<String>();
        for (int i=0; i < client.getNumFields(); i++){
            inputs.add(client.getFieldContents(i));
        }
        if (inputs.size() == client.getNumFields())
            return Status.OK;
        else
            return failureStatus;
    }

}

