package com.redhat.installer.asconfiguration.jdbc.constant;

import java.util.ArrayList;
import java.util.HashMap;



/**
 * Constants class for both JBoss* panels and any derivatives
 * @author thauser
 *
 */
public final class JBossJDBCConstants
{
    // IBM
    public static final String IBM_VENDOR_NAME = "IBM DB2";
    public static final String IBM_JDBC_NAME = "ibmdb2";
    public static final String IBM_MODULE_NAME = "com.ibm.db2";
    public static final String IBM_XA_DS_NAME = "com.ibm.db2.jcc.DB2XADataSource";
    public static final String IBM_DRIVER_CLASS_NAME = "com.ibm.db2.jcc.DB2Driver";
    public static final String IBM_DRIVER_CLASS_CHECK = IBM_DRIVER_CLASS_NAME.replace('.', '/').concat(".class");
    public static final String IBM_DIR_STRUCT = "modules/com/ibm/db2/main";
    public static final String IBM_DIALECT = "DB2Dialect";
    public static final String IBM_CONN_URL = "jdbc:db2://SERVER_NAME:PORT/DATABASE_NAME";

    // Sybase
    public static final String SYBASE_VENDOR_NAME = "Sybase jConn";
    public static final String SYBASE_JDBC_NAME = "sybase";
    public static final String SYBASE_MODULE_NAME = "com.sybase.jconn";
    public static final String SYBASE_XA_DS_NAME = "com.sybase.jdbc4.jdbc.SybXADataSource";
    public static final String SYBASE_DRIVER_CLASS_NAME = "com.sybase.jdbc4.jdbc.SybDriver";
    public static final String SYBASE_DRIVER_CLASS_CHECK = SYBASE_DRIVER_CLASS_NAME.replace('.', '/').concat(".class");
    public static final String SYBASE_DIR_STRUCT = "modules/com/sybase/jconn/main";
    public static final String SYBASE_DIALECT = "sybase";
    public static final String SYBASE_CONN_URL = "jdbc:sybase:Tds:localhost:5000/DATABASE";

    // MySQL
    public static final String MYSQL_VENDOR_NAME = "MySQL";
    public static final String MYSQL_JDBC_NAME = "mysql";
    public static final String MYSQL_MODULE_NAME = "com.mysql";
    public static final String MYSQL_XA_DS_NAME = "com.mysql.cj.jdbc.MysqlXADataSource";
    public static final String MYSQL_DRIVER_CLASS_NAME = "com.mysql.cj.jdbc.Driver";
    public static final String MYSQL_DRIVER_CLASS_CHECK = MYSQL_DRIVER_CLASS_NAME.replace('.','/').concat(".class");
    public static final String MYSQL_DIR_STRUCT = "modules/com/mysql/main";
    public static final String MYSQL_DIALECT = "MySQL5InnoDBDialect";
    public static final String MYSQL_CONN_URL = "jdbc:mysql://SERVER_NAME:PORT/DATABASE_NAME";
    
    // postgresql
    public static final String POSTGRESQL_VENDOR_NAME = "PostgreSQL";
    public static final String POSTGRESQL_JDBC_NAME = "postgresql";
    public static final String POSTGRESQL_MODULE_NAME = "org.postgresql";
    public static final String POSTGRESQL_XA_DS_NAME = "org.postgresql.xa.PGXADataSource";
    public static final String POSTGRESQL_DRIVER_CLASS_NAME = "org.postgresql.Driver";
    public static final String POSTGRESQL_DRIVER_CLASS_CHECK = POSTGRESQL_DRIVER_CLASS_NAME.replace('.', '/').concat(".class");
    public static final String POSTGRESQL_DIR_STRUCT = "modules/org/postgresql/main";
    public static final String POSTGRESQL_DIALECT = "PostgreSQLDialect";
    public static final String POSTGRESQL_CONN_URL = "jdbc:postgresql://SERVER_NAME:PORT/DATABASE_NAME";

    // microsoft
    public static final String MICROSOFT_VENDOR_NAME = "Microsoft SQL Server";
    public static final String MICROSOFT_JDBC_NAME = "sqlserver";
    public static final String MICROSOFT_MODULE_NAME = "com.microsoft.sqlserver";
    public static final String MICROSOFT_XA_DS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerXADataSource";
    public static final String MICROSOFT_DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    public static final String MICROSOFT_DRIVER_CLASS_CHECK = MICROSOFT_DRIVER_CLASS_NAME.replace('.', '/').concat(".class");
    public static final String MICROSOFT_DIR_STRUCT = "modules/com/microsoft/sqlserver/main";
    public static final String MICROSOFT_DIALECT = "SQLServer2008Dialect";
    public static final String MICROSOFT_CONN_URL = "jdbc:sqlserver://SERVER_NAME:PORT;DatabaseName=DATABASE_NAME";
    
    // oracle
    public static final String ORACLE_VENDOR_NAME = "Oracle";
    public static final String ORACLE_JDBC_NAME = "oracle";
    public static final String ORACLE_MODULE_NAME = "oracle.jdbc";
    public static final String ORACLE_XA_DS_NAME = "oracle.jdbc.xa.client.OracleXADataSource";
    public static final String ORACLE_DRIVER_CLASS_NAME = "oracle.jdbc.OracleDriver";
    public static final String ORACLE_DRIVER_CLASS_CHECK = ORACLE_DRIVER_CLASS_NAME.replace('.', '/').concat(".class");
    public static final String ORACLE_DIR_STRUCT = "modules/oracle/jdbc/main";
    public static final String ORACLE_DIALECT = "Oracle10gDialect";
    public static final String ORACLE_CONN_URL = "jdbc:oracle:thin:@ORACLE_HOST:PORT:ORACLE_SID";
    
    // h2
    public static final String H2_VENDOR_NAME = "H2";
    public static final String H2_JDBC_NAME = "h2";
    public static final String H2_DRIVER_CLASS_NAME = "org.h2.Driver";
    public static final String H2_DRIVER_CLASS_CHECK = JBossJDBCConstants.H2_DRIVER_CLASS_NAME.replace('.','/').concat(".class");
    public static final String H2_DIR_STRUCT = "modules/system/layers/base/com/h2database/h2/main";
    public static final String H2_DIALECT = "H2Dialect";
    // can't have a nice default for h2 connection url :(


    public static final String MARIADB_JDBC_NAME = "mariadb";
    public static final String MARIADB_DRIVER_CLASS_NAME = "org.mariadb.jdbc.Driver";
    public static final String MARIADB_DRIVER_CLASS_CHECK = JBossJDBCConstants.MARIADB_DRIVER_CLASS_NAME.replace('.','/').concat(".class");
    public static final String MARIADB_CONN_URL = "jdbc:mariadb://SERVER_NAME:PORT/DATABASE_NAME";

    
    // Validation
    public static final String HAS_EQUAL_NOT_EMPTY_REG_EXP_PATTERN = "^.+=.+$";
    public static final String VAL_REG_EXP_PATTERN = "^((\\\"([^\\\"]+)\\\")|([^,=\\{\\}\\[\\]]+))+$";
    public static final String PROP_REG_EXP_PATTERN = "^((\\\"([^\\\"]+)\\\")|([^,=\\{\\}\\[\\]]+))+$";
    public static final String PROPERTY_REG_EXP_PATTERN =
            "^((\\\"([^\"]+)\\\")|([^,=\\{\\}\\[\\]]+))+=((\\\"([^\"]+)\\\")|([^,=\\{\\}\\[\\]]+))+$";
    
    //Default Properties
    public static final String DATABASE      = "DatabaseName";
    public static final String SERVER        = "ServerName";
    public static final String URL           = "Url";
    public static final String PROTOCOL      = "NetworkProtocol"; //"NetworkProtocol";
    public static final String SELECT_METHOD = "SelectMethod";
    public static final String RECOVERY_USER = "RecoveryUser";
    public static final String RECOVERY_PASS = "RecoveryPass";
    public static final String PORT          = "PortNumber";
    
    
    public static final String[][] IBM_DEFAULTS = {{JBossJDBCConstants.DATABASE, "ibmdb2db"}};
    
    public static final String[][] ORACLE_DEFAULTS = {{JBossJDBCConstants.URL, "jdbc:oracle:oci8:@tc"}};
    
    public static final String[][] MYSQL_DEFAULTS = {{JBossJDBCConstants.SERVER, "localhost"}
                                            ,{JBossJDBCConstants.DATABASE, "mysqldb"}};
    
    public static final String[][] POSTGRESQL_DEFAULTS = {{JBossJDBCConstants.SERVER, "localhost"}
                                            ,{JBossJDBCConstants.DATABASE, "postgresdb"}
                                            ,{JBossJDBCConstants.PORT, "5432"}};
    
    public static final String[][] MICROSOFT_DEFAULTS = {{JBossJDBCConstants.SERVER, "localhost"}
                                            ,{JBossJDBCConstants.DATABASE, "mssqldb"}
                                            ,{JBossJDBCConstants.SELECT_METHOD,"cursor"}};
    
    public static final String[][] SYBASE_DEFAULTS = {{JBossJDBCConstants.SERVER, "localhost"}
                                            ,{JBossJDBCConstants.DATABASE,"sybase"}
                                            ,{JBossJDBCConstants.PORT, "4100"}
                                            ,{JBossJDBCConstants.PROTOCOL, "Tds"}};
   
    //Use for JBossDatasourceConfigPanel -> DynamicPanels
    public static ArrayList<String> driverIndex = new ArrayList<String>(){{
        add(IBM_JDBC_NAME);
        add(SYBASE_JDBC_NAME);
        add(MYSQL_JDBC_NAME);
        add(POSTGRESQL_JDBC_NAME);
        add(MICROSOFT_JDBC_NAME);
        add(ORACLE_JDBC_NAME);
    }};

    public static final HashMap<String, String[][]> DEFAULTS_MAP = new HashMap<String, String[][]>();
   
    static {
        DEFAULTS_MAP.put(IBM_JDBC_NAME, IBM_DEFAULTS);
        DEFAULTS_MAP.put(SYBASE_JDBC_NAME, SYBASE_DEFAULTS);
        DEFAULTS_MAP.put(MYSQL_JDBC_NAME, MYSQL_DEFAULTS);
        DEFAULTS_MAP.put(POSTGRESQL_JDBC_NAME, POSTGRESQL_DEFAULTS);
        DEFAULTS_MAP.put(MICROSOFT_JDBC_NAME, MICROSOFT_DEFAULTS);
        DEFAULTS_MAP.put(ORACLE_JDBC_NAME, ORACLE_DEFAULTS);
    }
    
    public static final HashMap<String, String> VENDOR_PROPERTY_MAP = new HashMap<String, String>();
    static {
        VENDOR_PROPERTY_MAP.put(IBM_JDBC_NAME + ".DatabaseName", "");
        
        VENDOR_PROPERTY_MAP.put(ORACLE_JDBC_NAME + ".URL", "");
        
        VENDOR_PROPERTY_MAP.put(MYSQL_JDBC_NAME + ".ServerName", "");
        VENDOR_PROPERTY_MAP.put(MYSQL_JDBC_NAME + ".DatabaseName", "");
        
        VENDOR_PROPERTY_MAP.put(SYBASE_JDBC_NAME + ".ServerName", "");
        VENDOR_PROPERTY_MAP.put(SYBASE_JDBC_NAME + ".DatabaseName", "");
        VENDOR_PROPERTY_MAP.put(SYBASE_JDBC_NAME + ".PortNumber", "");
        VENDOR_PROPERTY_MAP.put(SYBASE_JDBC_NAME + ".NetworkProtocol", "");
        
        VENDOR_PROPERTY_MAP.put(POSTGRESQL_JDBC_NAME + ".ServerName", "");
        VENDOR_PROPERTY_MAP.put(POSTGRESQL_JDBC_NAME + ".DatabaseName", "");
        VENDOR_PROPERTY_MAP.put(POSTGRESQL_JDBC_NAME + ".PortNumber", "");
        
        VENDOR_PROPERTY_MAP.put(MICROSOFT_JDBC_NAME + ".ServerName", "");
        VENDOR_PROPERTY_MAP.put(MICROSOFT_JDBC_NAME + ".DatabaseName", "");
        VENDOR_PROPERTY_MAP.put(MICROSOFT_JDBC_NAME + ".SelectMethod", "");
    }
    
    public static final HashMap<String, String> SQL_DIALECT_MAP = new HashMap<String, String>();
    static {
    	SQL_DIALECT_MAP.put(IBM_JDBC_NAME, IBM_DIALECT);
    	SQL_DIALECT_MAP.put(MYSQL_JDBC_NAME, MYSQL_DIALECT);
    	SQL_DIALECT_MAP.put(POSTGRESQL_JDBC_NAME, POSTGRESQL_DIALECT);
    	SQL_DIALECT_MAP.put(MICROSOFT_JDBC_NAME, MICROSOFT_DIALECT);
    	SQL_DIALECT_MAP.put(ORACLE_JDBC_NAME, ORACLE_DIALECT);
    	SQL_DIALECT_MAP.put(H2_JDBC_NAME, H2_DIALECT);
    	SQL_DIALECT_MAP.put(SYBASE_JDBC_NAME, SYBASE_DIALECT);
    }
    
    public static final HashMap<String,String> CLASSNAME_MAP = new HashMap<String, String>();
    static {
    	CLASSNAME_MAP.put(IBM_JDBC_NAME, IBM_DRIVER_CLASS_NAME);
    	CLASSNAME_MAP.put(MYSQL_JDBC_NAME, MYSQL_DRIVER_CLASS_NAME);
    	CLASSNAME_MAP.put(POSTGRESQL_JDBC_NAME, POSTGRESQL_DRIVER_CLASS_NAME);
    	CLASSNAME_MAP.put(MICROSOFT_JDBC_NAME, MICROSOFT_DRIVER_CLASS_NAME);
    	CLASSNAME_MAP.put(ORACLE_JDBC_NAME, ORACLE_DRIVER_CLASS_NAME);
        CLASSNAME_MAP.put(SYBASE_JDBC_NAME, SYBASE_DRIVER_CLASS_NAME);
    	CLASSNAME_MAP.put(H2_JDBC_NAME, H2_DRIVER_CLASS_NAME);
        CLASSNAME_MAP.put(MARIADB_JDBC_NAME, MARIADB_DRIVER_CLASS_NAME);
    }
    
    public static final HashMap<String,String> CLASSNAME_TO_JDBC_MAP = new HashMap<String,String>();
    static {
    	CLASSNAME_TO_JDBC_MAP.put(IBM_DRIVER_CLASS_NAME, IBM_JDBC_NAME);
    	CLASSNAME_TO_JDBC_MAP.put(MYSQL_DRIVER_CLASS_NAME, MYSQL_JDBC_NAME);
    	CLASSNAME_TO_JDBC_MAP.put(POSTGRESQL_DRIVER_CLASS_NAME, POSTGRESQL_JDBC_NAME);
    	CLASSNAME_TO_JDBC_MAP.put(MICROSOFT_DRIVER_CLASS_NAME, MICROSOFT_JDBC_NAME);
    	CLASSNAME_TO_JDBC_MAP.put(ORACLE_DRIVER_CLASS_NAME, ORACLE_JDBC_NAME);
    	CLASSNAME_TO_JDBC_MAP.put(H2_DRIVER_CLASS_NAME, H2_JDBC_NAME);
    	CLASSNAME_TO_JDBC_MAP.put(SYBASE_DRIVER_CLASS_NAME, SYBASE_JDBC_NAME);
        CLASSNAME_TO_JDBC_MAP.put(MARIADB_DRIVER_CLASS_NAME, MARIADB_JDBC_NAME);
    }
    
    public static final HashMap<String,String> DRIVER_JAR_PATH = new HashMap<String,String>();
    static {
    	DRIVER_JAR_PATH.put(IBM_JDBC_NAME, IBM_DIR_STRUCT);
    	DRIVER_JAR_PATH.put(MYSQL_JDBC_NAME, MYSQL_DIR_STRUCT);
    	DRIVER_JAR_PATH.put(POSTGRESQL_JDBC_NAME, POSTGRESQL_DIR_STRUCT);
    	DRIVER_JAR_PATH.put(MICROSOFT_JDBC_NAME, MICROSOFT_DIR_STRUCT);
    	DRIVER_JAR_PATH.put(ORACLE_JDBC_NAME, ORACLE_DIR_STRUCT);
    	DRIVER_JAR_PATH.put(H2_JDBC_NAME, H2_DIR_STRUCT);
    }
    
    public static final HashMap<String,String> CONN_URL_MAP = new HashMap<String,String>();
    static {
    	CONN_URL_MAP.put(IBM_JDBC_NAME, IBM_CONN_URL);
    	CONN_URL_MAP.put(MYSQL_JDBC_NAME, MYSQL_CONN_URL);
    	CONN_URL_MAP.put(POSTGRESQL_JDBC_NAME, POSTGRESQL_CONN_URL);
    	CONN_URL_MAP.put(MICROSOFT_JDBC_NAME, MICROSOFT_CONN_URL);
    	CONN_URL_MAP.put(ORACLE_JDBC_NAME, ORACLE_CONN_URL);
    	CONN_URL_MAP.put(SYBASE_JDBC_NAME, SYBASE_CONN_URL);
    }
    
    public static final ArrayList<String> CLASSNAME_LIST = new ArrayList<String>();
    static {
    	CLASSNAME_LIST.add(IBM_DRIVER_CLASS_NAME);
    	CLASSNAME_LIST.add(MYSQL_DRIVER_CLASS_NAME);
    	CLASSNAME_LIST.add(POSTGRESQL_DRIVER_CLASS_NAME);
    	CLASSNAME_LIST.add(MICROSOFT_DRIVER_CLASS_NAME);
    	CLASSNAME_LIST.add(ORACLE_DRIVER_CLASS_NAME);
    	CLASSNAME_LIST.add(SYBASE_DRIVER_CLASS_NAME);
    	CLASSNAME_LIST.add(H2_DRIVER_CLASS_NAME);
        CLASSNAME_LIST.add(MARIADB_DRIVER_CLASS_NAME);
    }
}

