package com.redhat.installer.asconfiguration.action;

import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.PanelAction;
import com.izforge.izpack.installer.PanelActionConfiguration;
import com.izforge.izpack.util.AbstractUIHandler;
import com.redhat.installer.asconfiguration.jdbc.constant.JBossJDBCConstants;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by thauser on 7/28/15.
 */
public class SetQuartzJobDelegate implements PanelAction {
    private static final Map<String,String> delegateMap;

    static {
        delegateMap = new HashMap<String,String>();
        delegateMap.put(JBossJDBCConstants.IBM_JDBC_NAME, "DB2v6Delegate");
        delegateMap.put(JBossJDBCConstants.MYSQL_JDBC_NAME, "StdJDBCDelegate");
        delegateMap.put(JBossJDBCConstants.H2_JDBC_NAME, "StdJDBCDelegate");
        delegateMap.put(JBossJDBCConstants.POSTGRESQL_JDBC_NAME, "PostgreSQLDelegate");
        delegateMap.put(JBossJDBCConstants.MICROSOFT_JDBC_NAME, "MSSQLDelegate");
        delegateMap.put(JBossJDBCConstants.SYBASE_JDBC_NAME, "SybaseDelegate");
        delegateMap.put(JBossJDBCConstants.ORACLE_JDBC_NAME, "oracle.OracleDelegate");
    }
    @Override
    public void executeAction(AutomatedInstallData idata, AbstractUIHandler abstractUIHandler) {
        String driverName = idata.getVariable("jdbc.driver.name");
        if (driverName != null){
            idata.setVariable("quartz.jobstore.delegate", delegateMap.get(driverName));
        }
    }

    @Override
    public void initialize(PanelActionConfiguration panelActionConfiguration) {

    }
}
