package org.jboss.brmsbpmsuite.patching.client;

import org.junit.Test;
import org.osgi.framework.Version;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

// This tests versions against the specified in version.properties testing file
public class VersionCheckerTest {

    @Test
    public void aCompatibleVersionIsValid() {
        Version compatibleVersion = Version.parseVersion("6.2.0.Final-redhat-1");
        VersionChecker versionChecker = VersionCheckerProvider.getInstance();

        assertThat(versionChecker.isValidForVersion(compatibleVersion), is(true));
    }

    @Test
    public void theLowerCompatibleVersionIsValid() {
        Version compatibleVersion = Version.parseVersion("6.1.0.Final-redhat-2");
        VersionChecker versionChecker = VersionCheckerProvider.getInstance();

        assertThat(versionChecker.isValidForVersion(compatibleVersion), is(true));
    }

    @Test
    public void theHigherCompatibleVersionIsValid() {
        Version compatibleVersion = Version.parseVersion("6.2.1.Final-redhat-2");
        VersionChecker versionChecker = VersionCheckerProvider.getInstance();

        assertThat(versionChecker.isValidForVersion(compatibleVersion), is(true));
    }

    @Test
    public void AnIncompatibleLesserVersionIsNotValid() {
        Version incompatibleVersion = Version.parseVersion("6.0.1.Final-redhat-3");
        VersionChecker versionChecker = VersionCheckerProvider.getInstance();

        assertThat(versionChecker.isValidForVersion(incompatibleVersion), is(false));
    }

    @Test
    public void AnIncompatibleGreaterVersionIsNotValid() {
        Version incompatibleVersion = Version.parseVersion("6.2.2.Final-redhat-1");
        VersionChecker versionChecker = VersionCheckerProvider.getInstance();

        assertThat(versionChecker.isValidForVersion(incompatibleVersion), is(false));
    }

    @Test
    public void AnIncompatibleNonFinalVersionIsNotValid() {
        Version incompatibleVersion = Version.parseVersion("6.1.0.GA-redhat-2");
        VersionChecker versionChecker = VersionCheckerProvider.getInstance();

        assertThat(versionChecker.isValidForVersion(incompatibleVersion), is(false));
    }

}