package org.jboss.brmsbpmsuite.patching.client;

import com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import java.io.File;
import java.util.Collection;

@RunWith(Parameterized.class)
public class ValidRootsDistributionCheckerFactoryTest extends BaseClientPatcherTest {

    private static File validRootsBasedir = getCPResourceAsFile("/distribution-checker-test/valid-roots");

    @Parameterized.Parameters(name = "{index}: {0}-{1}, root={2}")
    public static Collection<Object[]> data() {
        return Lists.newArrayList(new Object[][]{
                        // individual WARs
                        {DistributionType.RHPAM_EAP7X_BC, TargetProduct.RHPAM, "eap6.x-bpmsuite-2/business-central.war"},
                        {DistributionType.RHPAM_EE8_KIE, TargetProduct.RHPAM, "eap6.x-bpmsuite-2/kie-server.war"},
                        {DistributionType.RHPAM_EE7_CTRL, TargetProduct.RHPAM, "ee-rhpam/controller.war"}
                }
        );
    }

    @Parameterized.Parameter(0)
    public DistributionType distributionType;

    @Parameterized.Parameter(1)
    public TargetProduct targetProduct;

    @Parameterized.Parameter(2)
    public String distributionRootPath;

    @Test
    public void shouldRecognizeValidDistributionRoot() {
        DistributionChecker checker = DistributionCheckerFactory.create(distributionType, targetProduct);
        Assert.assertTrue("Distribution root should be marked as valid!",
                checker.check(new File(validRootsBasedir, distributionRootPath)));
    }

}
