import { addDecorator, addParameters } from '@storybook/react';
import { withInfo } from '@storybook/addon-info';
import { withA11y } from '@storybook/addon-a11y';
import { withKnobs } from '@storybook/addon-knobs';
import { withLinks } from '@storybook/addon-links';
import { withNotes } from '@storybook/addon-notes';
import { create } from '@storybook/theming';
import { INITIAL_VIEWPORTS } from '@storybook/addon-viewport';
import './vendor.css';

addParameters({
  options: {
    theme: create({
      base: 'light',
      brandTitle: 'syndesis/auto-form',
      brandImage:
        'data:image/png;base64,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',
    }),
  },
});

/* this MUST always be the first decorator */
addDecorator(
  withInfo({
    inline: false,
    header: false,
    maxPropsIntoLine: 1,
  })
);

/* load the accessibility check addon */
addDecorator(withA11y);

/* load the knobs addon */
addDecorator(withKnobs);

/* load the links addon */
addDecorator(withLinks);

/* load the notes addon */
addDecorator(withNotes);

/* add a responsive viewport */
const newViewports = {
  bp768: {
    name: 'Breakpoint: 768px',
    styles: {
      width: '768px',
      height: '432px',
    },
  },
  bp992: {
    name: 'Breakpoint: 992px',
    styles: {
      width: '992px',
      height: '558px',
    },
  },
  bp1200: {
    name: 'Breakpoint: 1200px',
    styles: {
      width: '1200px',
      height: '675px',
    },
  },
};

addParameters({
  viewport: {
    viewports: {
      ...newViewports,
      ...INITIAL_VIEWPORTS,
    },
  },
});
