package com.redhat.fuse.boosters.istio.dt;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.web.client.TestRestTemplate;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.web.client.ResponseExtractor;

import java.io.IOException;

@RunWith(SpringRunner.class)
@SpringBootTest(webEnvironment = SpringBootTest.WebEnvironment.RANDOM_PORT)
public class HttpRequestTest {

    @LocalServerPort
    private int port;

    @Autowired
    private TestRestTemplate restTemplate;

    @Test
    public void greetingsShouldReturn500() throws Exception {
        Assert.assertEquals(new Integer(500), this.restTemplate.execute("http://localhost:" + port + "/camel/greetings",
                HttpMethod.GET, null, new ResponseExtractor<Integer>() {

                    @Override
                    public Integer extractData(ClientHttpResponse response) throws IOException {
                        return response.getRawStatusCode();
                    }
                }));
    }

    @Test
    public void healthShouldReturnOkMessage() throws Exception {
        Assert.assertEquals("{\"status\":\"UP\"}",
                this.restTemplate.getForObject("http://localhost:" + port + "/actuator/health", String.class));
    }
}