/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.web3j;

public interface Web3jConstants {
    String WEB3_CLIENT_VERSION = "WEB3_CLIENT_VERSION";
    String WEB3_SHA3 = "WEB3_SHA3";
    String NET_VERSION = "NET_VERSION";
    String NET_LISTENING = "NET_LISTENING";
    String NET_PEER_COUNT = "NET_PEER_COUNT";
    String ETH_PROTOCOL_VERSION = "ethProtocolVersion";
    String ETH_COINBASE = "ETH_COINBASE";
    String ETH_SYNCING = "ETH_SYNCING";
    String ETH_MINING = "ETH_MINING";
    String ETH_HASHRATE = "ETH_HASHRATE";
    String ETH_GAS_PRICE = "ETH_GAS_PRICE";
    String ETH_ACCOUNTS = "ETH_ACCOUNTS";
    String ETH_BLOCK_NUMBER = "ETH_BLOCK_NUMBER";
    String ETH_GET_BALANCE = "ETH_GET_BALANCE";
    String ETH_GET_STORAGE_AT = "ETH_GET_STORAGE_AT";
    String ETH_GET_TRANSACTION_COUNT = "ETH_GET_TRANSACTION_COUNT";
    String ETH_GET_BLOCK_TRANSACTION_COUNT_BY_HASH = "ETH_GET_BLOCK_TRANSACTION_COUNT_BY_HASH";
    String ETH_GET_BLOCK_TRANSACTION_COUNT_BY_NUMBER = "ETH_GET_BLOCK_TRANSACTION_COUNT_BY_NUMBER";
    String ETH_GET_UNCLE_COUNT_BY_BLOCK_HASH = "ETH_GET_UNCLE_COUNT_BY_BLOCK_HASH";
    String ETH_GET_UNCLE_COUNT_BY_BLOCK_NUMBER = "ETH_GET_UNCLE_COUNT_BY_BLOCK_NUMBER";
    String ETH_GET_CODE = "ETH_GET_CODE";
    String ETH_SIGN = "ETH_SIGN";
    String ETH_SEND_TRANSACTION = "ETH_SEND_TRANSACTION";
    String ETH_SEND_RAW_TRANSACTION = "ETH_SEND_RAW_TRANSACTION";
    String ETH_CALL = "ETH_CALL";
    String ETH_ESTIMATE_GAS = "ETH_ESTIMATE_GAS";
    String ETH_GET_BLOCK_BY_HASH = "ETH_GET_BLOCK_BY_HASH";
    String ETH_GET_BLOCK_BY_NUMBER = "ETH_GET_BLOCK_BY_NUMBER";
    String ETH_GET_TRANSACTION_BY_HASH = "ETH_GET_TRANSACTION_BY_HASH";
    String ETH_GET_TRANSACTION_BY_BLOCK_HASH_AND_INDEX = "ETH_GET_TRANSACTION_BY_BLOCK_HASH_AND_INDEX";
    String ETH_GET_TRANSACTION_BY_BLOCK_NUMBER_AND_INDEX = "ETH_GET_TRANSACTION_BY_BLOCK_NUMBER_AND_INDEX";
    String ETH_GET_TRANSACTION_RECEIPT = "ETH_GET_TRANSACTION_RECEIPT";
    String ETH_GET_UNCLE_BY_BLOCK_HASH_AND_INDEX = "ETH_GET_UNCLE_BY_BLOCK_HASH_AND_INDEX";
    String ETH_GET_UNCLE_BY_BLOCK_NUMBER_AND_INDEX = "ETH_GET_UNCLE_BY_BLOCK_NUMBER_AND_INDEX";
    String ETH_GET_COMPILERS = "ETH_GET_COMPILERS";
    String ETH_COMPILE_LLL = "ETH_COMPILE_LLL";
    String ETH_COMPILE_SOLIDITY = "ETH_COMPILE_SOLIDITY";
    String ETH_COMPILE_SERPENT = "ETH_COMPILE_SERPENT";
    String ETH_NEW_FILTER = "ETH_NEW_FILTER";
    String ETH_NEW_BLOCK_FILTER = "ETH_NEW_BLOCK_FILTER";
    String ETH_NEW_PENDING_TRANSACTION_FILTER = "ETH_NEW_PENDING_TRANSACTION_FILTER";
    String ETH_UNINSTALL_FILTER = "ETH_UNINSTALL_FILTER";
    String ETH_GET_FILTER_CHANGES = "ETH_GET_FILTER_CHANGES";
    String ETH_GET_FILTER_LOGS = "ETH_GET_FILTER_LOGS";
    String ETH_GET_LOGS = "ETH_GET_LOGS";
    String ETH_GET_WORK = "ETH_GET_WORK";
    String ETH_SUBMIT_WORK = "ETH_SUBMIT_WORK";
    String ETH_SUBMIT_HASHRATE = "ETH_SUBMIT_HASHRATE";
    String DB_PUT_STRING = "DB_PUT_STRING";
    String DB_GET_STRING = "DB_GET_STRING";
    String DB_PUT_HEX = "DB_PUT_HEX";
    String DB_GET_HEX = "DB_GET_HEX";
    String SHH_VERSION = "SHH_VERSION";
    String SHH_POST = "SHH_POST";
    String SHH_NEW_IDENTITY = "SHH_NEW_IDENTITY";
    String SHH_HAS_IDENTITY = "SHH_HAS_IDENTITY";
    String SHH_NEW_GROUP = "SHH_NEW_GROUP";
    String SHH_ADD_TO_GROUP = "SHH_ADD_TO_GROUP";
    String SHH_NEW_FILTER = "SHH_NEW_FILTER";
    String SHH_UNINSTALL_FILTER = "SHH_UNINSTALL_FILTER";
    String SHH_GET_FILTER_CHANGES = "SHH_GET_FILTER_CHANGES";
    String SHH_GET_MESSAGES = "SHH_GET_MESSAGES";

    String QUORUM_ETH_SEND_TRANSACTION = "QUORUM_ETH_SEND_TRANSACTION";
    String QUORUM_NODE_INFO = "QUORUM_NODE_INFO";
    String QUORUM_CANONICAL_HASH = "QUORUM_CANONICAL_HASH";
    String QUORUM_VOTE = "QUORUM_VOTE";
    String QUORUM_MAKE_BLOCK = "QUORUM_MAKE_BLOCK";
    String QUORUM_PAUSE_BLOCK_MAKER = "QUORUM_PAUSE_BLOCK_MAKER";
    String QUORUM_RESUME_BLOCK_MAKER = "QUORUM_RESUME_BLOCK_MAKER";
    String QUORUM_IS_BLOCK_MAKER = "QUORUM_IS_BLOCK_MAKER";
    String QUORUM_IS_VOTER = "QUORUM_IS_VOTER";
    String QUORUM_GET_PRIVATE_PAYLOAD = "QUORUM_GET_PRIVATE_PAYLOAD";

    String ETH_LOG_OBSERVABLE = "ETH_LOG_OBSERVABLE";
    String ETH_BLOCK_HASH_OBSERVABLE = "ETH_BLOCK_HASH_OBSERVABLE";
    String ETH_PENDING_TRANSACTION_HASH_OBSERVABLE = "ETH_PENDING_TRANSACTION_HASH_OBSERVABLE";
    String TRANSACTION_OBSERVABLE = "TRANSACTION_OBSERVABLE";
    String PENDING_TRANSACTION_OBSERVABLE = "PENDING_TRANSACTION_OBSERVABLE";
    String BLOCK_OBSERVABLE = "BLOCK_OBSERVABLE";
    String REPLAY_BLOCKS_OBSERVABLE = "REPLAY_BLOCKS_OBSERVABLE";
    String REPLAY_TRANSACTIONS_OBSERVABLE = "REPLAY_TRANSACTIONS_OBSERVABLE";
    String CATCH_UP_TO_LATEST_BLOCK_OBSERVABLE = "CATCH_UP_TO_LATEST_BLOCK_OBSERVABLE";
    String CATCH_UP_TO_LATEST_TRANSACTION_OBSERVABLE = "CATCH_UP_TO_LATEST_TRANSACTION_OBSERVABLE";
    String CATCH_UP_TO_LATEST_AND_SUBSCRIBE_TO_NEW_BLOCKS_OBSERVABLE = "CATCH_UP_TO_LATEST_AND_SUBSCRIBE_TO_NEW_BLOCKS_OBSERVABLE";
    String CATCH_UP_TO_LATEST_AND_SUBSCRIBE_TO_NEW_TRANSACTIONS_OBSERVABLE = "CATCH_UP_TO_LATEST_AND_SUBSCRIBE_TO_NEW_TRANSACTIONS_OBSERVABLE";

    String ID = "ID";
    String OPERATION = "OPERATION";
    String TRANSACTION = "TRANSACTION";
    String AT_BLOCK = "AT_BLOCK";
    String ADDRESS = "ADDRESS";
    String ADDRESSES = "ADDRESSES";
    String FROM_ADDRESS = "FROM_ADDRESS";
    String TO_ADDRESS = "TO_ADDRESS";
    String POSITION = "POSITION";
    String BLOCK_HASH = "BLOCK_HASH";
    String TRANSACTION_HASH = "TRANSACTION_HASH";
    String SHA3_HASH_OF_DATA_TO_SIGN = "SHA3_HASH_OF_DATA_TO_SIGN";
    String SIGNED_TRANSACTION_DATA = "SIGNED_TRANSACTION_DATA";
    String FULL_TRANSACTION_OBJECTS = "FULL_TRANSACTION_OBJECTS";
    String INDEX = "INDEX";
    String SOURCE_CODE = "SOURCE_CODE";
    String FILTER_ID = "FILTER_ID";
    String DATABASE_NAME = "DATABASE_NAME";
    String KEY_NAME = "KEY_NAME";
    String NONCE = "NONCE";
    String HEADER_POW_HASH = "HEADER_POW_HASH";
    String MIX_DIGEST = "MIX_DIGEST";
    String CLIENT_ID = "CLIENT_ID";
    String GAS_PRICE = "GAS_PRICE";
    String GAS_LIMIT = "GAS_LIMIT";
    String VALUE = "VALUE";
    String DATA = "DATA";
    String FROM_BLOCK = "FROM_BLOCK";
    String TO_BLOCK = "TO_BLOCK";
    String TOPICS = "TOPICS";
    String PRIORITY = "PRIORITY";
    String TTL = "TTL";
    String PRIVATE_FOR = "PRIVATE_FOR";

    String ERROR_CODE = "ERROR_CODE";
    String ERROR_DATA = "ERROR_DATA";
    String ERROR_MESSAGE = "ERROR_MESSAGE";
}
