/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.stm.japi;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConversions$;
import scala.concurrent.stm.InTxn;
import scala.concurrent.stm.MaybeTxn$;
import scala.concurrent.stm.Ref;
import scala.concurrent.stm.Ref$;
import scala.concurrent.stm.TArray;
import scala.concurrent.stm.TArray$;
import scala.concurrent.stm.TMap;
import scala.concurrent.stm.TMap$;
import scala.concurrent.stm.TSet;
import scala.concurrent.stm.TSet$;
import scala.concurrent.stm.Txn;
import scala.concurrent.stm.Txn$;
import scala.concurrent.stm.japi.STM;
import scala.concurrent.stm.japi.STMHelpers$;
import scala.concurrent.stm.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.NoManifest$;
import scala.runtime.BoxedUnit;

public final class STM$ {
    public static final STM$ MODULE$;

    static {
        new STM$();
    }

    public <A> Ref.View<A> newRef(A initialValue) {
        return Ref$.MODULE$.apply(initialValue, NoManifest$.MODULE$).single();
    }

    public <A, B> TMap.View<A, B> newTMap() {
        return TMap$.MODULE$.empty().single();
    }

    public <A, B> Map<A, B> newMap() {
        return JavaConversions$.MODULE$.mutableMapAsJavaMap(this.newTMap());
    }

    public <A> TSet.View<A> newTSet() {
        return TSet$.MODULE$.empty().single();
    }

    public <A> Set<A> newSet() {
        return JavaConversions$.MODULE$.mutableSetAsJavaSet(this.newTSet());
    }

    public <A> TArray.View<A> newTArray(int length) {
        return TArray$.MODULE$.ofDim(length, ManifestFactory$.MODULE$.Object()).single();
    }

    public <A> List<A> newArrayAsList(int length) {
        return JavaConversions$.MODULE$.mutableSeqAsJavaList(this.newTArray(length));
    }

    public void atomic(Runnable runnable) {
        package$.MODULE$.atomic().apply(new Serializable(runnable){
            public static final long serialVersionUID = 0L;
            private final Runnable runnable$1;

            public final void apply(InTxn txn) {
                this.runnable$1.run();
            }
            {
                this.runnable$1 = runnable$1;
            }
        }, MaybeTxn$.MODULE$.unknown());
    }

    public <A> A atomic(Callable<A> callable) {
        return package$.MODULE$.atomic().apply(STMHelpers$.MODULE$.callableToAtomicBlock(callable), MaybeTxn$.MODULE$.unknown());
    }

    public void retry() {
        Option<InTxn> option2 = Txn$.MODULE$.findCurrent(MaybeTxn$.MODULE$.unknown());
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            InTxn txn = (InTxn)some.x();
            throw Txn$.MODULE$.retry(txn);
        }
        if (None$.MODULE$.equals(option2)) {
            throw new IllegalStateException("retry outside atomic");
        }
        throw new MatchError(option2);
    }

    public void retryFor(long timeoutMillis) {
        Option<InTxn> option2 = Txn$.MODULE$.findCurrent(MaybeTxn$.MODULE$.unknown());
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            InTxn txn = (InTxn)some.x();
            Txn$.MODULE$.retryFor(timeoutMillis, Txn$.MODULE$.retryFor$default$2(), txn);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (None$.MODULE$.equals(option2)) {
            throw new IllegalStateException("retry outside atomic");
        }
        throw new MatchError(option2);
    }

    public <A> void transform(Ref.View<A> ref2, STM.Transformer<A> f2) {
        ref2.transform(STMHelpers$.MODULE$.transformerToFunction(f2));
    }

    public <A> A getAndTransform(Ref.View<A> ref2, STM.Transformer<A> f2) {
        return ref2.getAndTransform(STMHelpers$.MODULE$.transformerToFunction(f2));
    }

    public <A> A transformAndGet(Ref.View<A> ref2, STM.Transformer<A> f2) {
        return ref2.transformAndGet(STMHelpers$.MODULE$.transformerToFunction(f2));
    }

    public void increment(Ref.View<Integer> ref2, int delta) {
        ref2.transform((Function1<Integer, Integer>)((Object)new Serializable(delta){
            public static final long serialVersionUID = 0L;
            private final int delta$1;

            public final Integer apply(Integer v) {
                return Predef$.MODULE$.int2Integer(v + this.delta$1);
            }
            {
                this.delta$1 = delta$1;
            }
        }));
    }

    public void increment(Ref.View<Long> ref2, long delta) {
        ref2.transform((Function1<Long, Long>)((Object)new Serializable(delta){
            public static final long serialVersionUID = 0L;
            private final long delta$2;

            public final Long apply(Long v) {
                return Predef$.MODULE$.long2Long(v + this.delta$2);
            }
            {
                this.delta$2 = delta$2;
            }
        }));
    }

    private InTxn activeTxn() {
        Option<InTxn> option2 = Txn$.MODULE$.findCurrent(MaybeTxn$.MODULE$.unknown());
        if (option2 instanceof Some) {
            InTxn txn;
            Some some = (Some)option2;
            InTxn inTxn = txn = (InTxn)some.x();
            return inTxn;
        }
        if (None$.MODULE$.equals(option2)) {
            throw new IllegalStateException("not in a transaction");
        }
        throw new MatchError(option2);
    }

    public void afterCommit(Runnable task2) {
        Txn$.MODULE$.afterCommit((Function1<Txn.Status, BoxedUnit>)((Object)new Serializable(task2){
            public static final long serialVersionUID = 0L;
            private final Runnable task$1;

            public final void apply(Txn.Status status) {
                this.task$1.run();
            }
            {
                this.task$1 = task$1;
            }
        }), this.activeTxn());
    }

    public void afterRollback(Runnable task2) {
        Txn$.MODULE$.afterRollback((Function1<Txn.Status, BoxedUnit>)((Object)new Serializable(task2){
            public static final long serialVersionUID = 0L;
            private final Runnable task$2;

            public final void apply(Txn.Status status) {
                this.task$2.run();
            }
            {
                this.task$2 = task$2;
            }
        }), this.activeTxn());
    }

    public void afterCompletion(Runnable task2) {
        Txn$.MODULE$.afterCompletion((Function1<Txn.Status, BoxedUnit>)((Object)new Serializable(task2){
            public static final long serialVersionUID = 0L;
            private final Runnable task$3;

            public final void apply(Txn.Status status) {
                this.task$3.run();
            }
            {
                this.task$3 = task$3;
            }
        }), this.activeTxn());
    }

    private STM$() {
        MODULE$ = this;
    }
}

