/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.joda.convert.FromString;
import org.joda.convert.FromStringFactory;
import org.joda.convert.MethodConstructorStringConverter;
import org.joda.convert.MethodsStringConverter;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.ToString;

final class AnnotationStringConverterFactory
implements StringConverterFactory {
    static final StringConverterFactory INSTANCE = new AnnotationStringConverterFactory();

    private AnnotationStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        return this.findAnnotatedConverter(cls);
    }

    private <T> StringConverter<T> findAnnotatedConverter(Class<T> cls) {
        Method toString2 = this.findToStringMethod(cls);
        if (toString2 == null) {
            return null;
        }
        MethodConstructorStringConverter<T> con = this.findFromStringConstructor(cls, toString2);
        MethodsStringConverter<T> mth = this.findFromStringMethod(cls, toString2, con == null);
        if (con == null && mth == null) {
            throw new IllegalStateException("Class annotated with @ToString but not with @FromString: " + cls.getName());
        }
        if (con != null && mth != null) {
            throw new IllegalStateException("Both method and constructor are annotated with @FromString: " + cls.getName());
        }
        return con != null ? con : mth;
    }

    private Method findToStringMethod(Class<?> cls) {
        Method matched = null;
        for (Class<?> loopCls = cls; loopCls != null && matched == null; loopCls = loopCls.getSuperclass()) {
            Method[] methods2;
            for (Method method : methods2 = loopCls.getDeclaredMethods()) {
                ToString toString2 = method.getAnnotation(ToString.class);
                if (toString2 == null) continue;
                if (matched != null) {
                    throw new IllegalStateException("Two methods are annotated with @ToString: " + cls.getName());
                }
                matched = method;
            }
        }
        if (matched == null) {
            for (Class<?> loopIfc : this.eliminateEnumSubclass(cls).getInterfaces()) {
                Method[] methods3;
                for (Method method : methods3 = loopIfc.getDeclaredMethods()) {
                    ToString toString3 = method.getAnnotation(ToString.class);
                    if (toString3 == null) continue;
                    if (matched != null) {
                        throw new IllegalStateException("Two methods are annotated with @ToString on interfaces: " + cls.getName());
                    }
                    matched = method;
                }
            }
        }
        return matched;
    }

    private <T> MethodConstructorStringConverter<T> findFromStringConstructor(Class<T> cls, Method toString2) {
        Constructor<FromString> con;
        try {
            con = cls.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException ex) {
            try {
                con = cls.getDeclaredConstructor(CharSequence.class);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
        FromString fromString = con.getAnnotation(FromString.class);
        if (fromString == null) {
            return null;
        }
        return new MethodConstructorStringConverter<T>(cls, toString2, con);
    }

    private <T> MethodsStringConverter<T> findFromStringMethod(Class<T> cls, Method toString2, boolean searchSuperclasses) {
        for (Class<T> loopCls = cls; loopCls != null; loopCls = loopCls.getSuperclass()) {
            Method fromString = this.findFromString(loopCls);
            if (fromString != null) {
                return new MethodsStringConverter<T>(cls, toString2, fromString, loopCls);
            }
            if (!searchSuperclasses) break;
        }
        MethodsStringConverter<T> matched = null;
        if (searchSuperclasses) {
            for (Class<?> loopIfc : this.eliminateEnumSubclass(cls).getInterfaces()) {
                Method fromString = this.findFromString(loopIfc);
                if (fromString == null) continue;
                if (matched != null) {
                    throw new IllegalStateException("Two different interfaces are annotated with @FromString or @FromStringFactory: " + cls.getName());
                }
                matched = new MethodsStringConverter<T>(cls, toString2, fromString, loopIfc);
            }
        }
        return matched;
    }

    private Method findFromString(Class<?> cls) {
        Method[] methods2 = cls.getDeclaredMethods();
        Method matched = null;
        for (Method method : methods2) {
            FromString fromString = method.getAnnotation(FromString.class);
            if (fromString == null) continue;
            if (matched != null) {
                throw new IllegalStateException("Two methods are annotated with @FromString: " + cls.getName());
            }
            matched = method;
        }
        FromStringFactory factory = cls.getAnnotation(FromStringFactory.class);
        if (factory != null) {
            Method[] factoryMethods;
            if (matched != null) {
                throw new IllegalStateException("Class annotated with @FromString and @FromStringFactory: " + cls.getName());
            }
            for (Method method : factoryMethods = factory.factory().getDeclaredMethods()) {
                FromString fromString;
                if (!cls.isAssignableFrom(method.getReturnType()) || (fromString = method.getAnnotation(FromString.class)) == null) continue;
                if (matched != null) {
                    throw new IllegalStateException("Two methods are annotated with @FromString on the factory: " + factory.factory().getName());
                }
                matched = method;
            }
        }
        return matched;
    }

    private Class<?> eliminateEnumSubclass(Class<?> cls) {
        Class<?> sup = cls.getSuperclass();
        if (sup != null && sup.getSuperclass() == Enum.class) {
            return sup;
        }
        return cls;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

