/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;

public class CanonicalTreeParser
extends AbstractTreeIterator {
    private static final byte[] EMPTY = new byte[0];
    private byte[] raw;
    private int prevPtr;
    private int currPtr;
    private int nextPtr;

    public CanonicalTreeParser() {
        this.reset(EMPTY);
    }

    public CanonicalTreeParser(byte[] prefix, ObjectReader reader, AnyObjectId treeId) throws IncorrectObjectTypeException, IOException {
        super(prefix);
        this.reset(reader, treeId);
    }

    private CanonicalTreeParser(CanonicalTreeParser p) {
        super(p);
    }

    @Deprecated
    public CanonicalTreeParser getParent() {
        return (CanonicalTreeParser)this.parent;
    }

    public void reset(byte[] treeData) {
        this.raw = treeData;
        this.prevPtr = -1;
        this.currPtr = 0;
        if (this.eof()) {
            this.nextPtr = 0;
        } else {
            this.parseEntry();
        }
    }

    public CanonicalTreeParser resetRoot(ObjectReader reader, AnyObjectId id2) throws IncorrectObjectTypeException, IOException {
        CanonicalTreeParser p = this;
        while (p.parent != null) {
            p = (CanonicalTreeParser)p.parent;
        }
        p.reset(reader, id2);
        return p;
    }

    public CanonicalTreeParser next() {
        CanonicalTreeParser p = this;
        while (p.nextPtr == p.raw.length) {
            if (p.parent == null) {
                p.currPtr = p.nextPtr;
                return p;
            }
            p = (CanonicalTreeParser)p.parent;
        }
        p.prevPtr = p.currPtr;
        p.currPtr = p.nextPtr;
        p.parseEntry();
        return p;
    }

    public void reset(ObjectReader reader, AnyObjectId id2) throws IncorrectObjectTypeException, IOException {
        this.reset(reader.open(id2, 2).getCachedBytes());
    }

    public CanonicalTreeParser createSubtreeIterator(ObjectReader reader, MutableObjectId idBuffer) throws IncorrectObjectTypeException, IOException {
        idBuffer.fromRaw(this.idBuffer(), this.idOffset());
        if (!FileMode.TREE.equals(this.mode)) {
            ObjectId me = idBuffer.toObjectId();
            throw new IncorrectObjectTypeException(me, "tree");
        }
        return this.createSubtreeIterator0(reader, idBuffer);
    }

    public final CanonicalTreeParser createSubtreeIterator0(ObjectReader reader, AnyObjectId id2) throws IOException {
        CanonicalTreeParser p = new CanonicalTreeParser(this);
        p.reset(reader, id2);
        return p;
    }

    public CanonicalTreeParser createSubtreeIterator(ObjectReader reader) throws IncorrectObjectTypeException, IOException {
        return this.createSubtreeIterator(reader, new MutableObjectId());
    }

    public boolean hasId() {
        return true;
    }

    public byte[] idBuffer() {
        return this.raw;
    }

    public int idOffset() {
        return this.nextPtr - 20;
    }

    public void reset() {
        if (!this.first()) {
            this.reset(this.raw);
        }
    }

    public boolean first() {
        return this.currPtr == 0;
    }

    public boolean eof() {
        return this.currPtr == this.raw.length;
    }

    public void next(int delta) {
        int ptr;
        if (delta == 1) {
            this.prevPtr = this.currPtr;
            this.currPtr = this.nextPtr;
            if (!this.eof()) {
                this.parseEntry();
            }
            return;
        }
        int end2 = this.raw.length;
        for (ptr = this.nextPtr; --delta > 0 && ptr != end2; ptr += 21) {
            this.prevPtr = ptr;
            while (this.raw[ptr] != 0) {
                ++ptr;
            }
        }
        if (delta != 0) {
            throw new ArrayIndexOutOfBoundsException(delta);
        }
        this.currPtr = ptr;
        if (!this.eof()) {
            this.parseEntry();
        }
    }

    public void back(int delta) {
        if (delta == 1 && 0 <= this.prevPtr) {
            this.currPtr = this.prevPtr;
            this.prevPtr = -1;
            if (!this.eof()) {
                this.parseEntry();
            }
            return;
        }
        if (delta <= 0) {
            throw new ArrayIndexOutOfBoundsException(delta);
        }
        int[] trace = new int[delta + 1];
        Arrays.fill(trace, -1);
        for (int ptr = 0; ptr != this.currPtr; ptr += 21) {
            System.arraycopy(trace, 1, trace, 0, delta);
            trace[delta] = ptr;
            while (this.raw[ptr] != 0) {
                ++ptr;
            }
        }
        if (trace[1] == -1) {
            throw new ArrayIndexOutOfBoundsException(delta);
        }
        this.prevPtr = trace[0];
        this.currPtr = trace[1];
        this.parseEntry();
    }

    private void parseEntry() {
        int ptr = this.currPtr;
        byte c = this.raw[ptr++];
        int tmp = c - 48;
        while (32 != (c = this.raw[ptr++])) {
            tmp <<= 3;
            tmp += c - 48;
        }
        this.mode = tmp;
        tmp = this.pathOffset;
        while ((c = this.raw[ptr++]) != 0) {
            try {
                this.path[tmp] = c;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                this.growPath(tmp);
                this.path[tmp] = c;
            }
            ++tmp;
        }
        this.pathLen = tmp;
        this.nextPtr = ptr + 20;
    }
}

