/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.PreUploadHook;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreUploadHookChain
implements PreUploadHook {
    private final PreUploadHook[] hooks;
    private final int count;

    public static PreUploadHook newChain(List<? extends PreUploadHook> hooks) {
        PreUploadHook[] newHooks = new PreUploadHook[hooks.size()];
        int i = 0;
        for (PreUploadHook preUploadHook : hooks) {
            if (preUploadHook == PreUploadHook.NULL) continue;
            newHooks[i++] = preUploadHook;
        }
        if (i == 0) {
            return PreUploadHook.NULL;
        }
        if (i == 1) {
            return newHooks[0];
        }
        return new PreUploadHookChain(newHooks, i);
    }

    @Override
    public void onBeginNegotiateRound(UploadPack up2, Collection<? extends ObjectId> wants, int cntOffered) throws ServiceMayNotContinueException {
        for (int i = 0; i < this.count; ++i) {
            this.hooks[i].onBeginNegotiateRound(up2, wants, cntOffered);
        }
    }

    @Override
    public void onEndNegotiateRound(UploadPack up2, Collection<? extends ObjectId> wants, int cntCommon, int cntNotFound, boolean ready2) throws ServiceMayNotContinueException {
        for (int i = 0; i < this.count; ++i) {
            this.hooks[i].onEndNegotiateRound(up2, wants, cntCommon, cntNotFound, ready2);
        }
    }

    @Override
    public void onSendPack(UploadPack up2, Collection<? extends ObjectId> wants, Collection<? extends ObjectId> haves) throws ServiceMayNotContinueException {
        for (int i = 0; i < this.count; ++i) {
            this.hooks[i].onSendPack(up2, wants, haves);
        }
    }

    private PreUploadHookChain(PreUploadHook[] hooks, int count2) {
        this.hooks = hooks;
        this.count = count2;
    }
}

